(function () {
  // noinspection ES6ModulesDependencies
  var CONST_BASE_TIME_UNIT = 1000
    , CONST_FRAME_FPS = 16
    , CONST_MAX_LABEL_WIDTH = 300
    , SELECTOR_SKIN_BOX = '.zydeco-skin-box'
    , SELECTOR_NAV_HEADER = '.layui-layout-admin .layui-header'
    , SELECTOR_SKIN_COLOR_PICKER = 'skin-color_picker-all-input'
    , $SELECTOR_SKIN_COLOR_PICKER = '#skin-color_picker-all-input'
    , CONST_NAV_HEADER_HEIGHT = 65
    , CONST_FIRST_RESIZE_TRIGGER_DELAY = 3
    , KEY_DIMENSION_OF_LAST_RESIZE = '__dimension_of_last_resize__'
    , KEY_DIMENSION_OF_FULLSCREEN = '__dimension_of_fullscreen__'
    , KEY_DIMENSION_BEFORE_FULLSCREEN = '__dimension_before_fullscreen__'
    , CONST_IS_RTL_LAYOUT = is_rtl_layout()
    , PRESET_SKIN_THEMES = {
    'blue_linear': {
      style: (function () {
        return (
          CONST_IS_RTL_LAYOUT
          ? {
              background: 'linear-gradient(45deg, #0B4182 1%, #1e88e5 64%, #40BAF5 97%);'
            }
          : {
              background: 'linear-gradient(45deg, #40BAF5 1%, #1e88e5 64%, #0B4182 97%);'
            });
      })()
    },
    'green_linear': {
      style: (function () {
        return (
          CONST_IS_RTL_LAYOUT
          ? {
              background: 'linear-gradient(45deg, #158334 1%, #24b94e 64%, #39e867 97%);'
            }
          : {
              background: 'linear-gradient(45deg, #39e867 1%, #24b94e 64%, #158334 97%);'
            });
      })()
    }
  };

    $.fn.easytimeproFillHead = function () {
    $('#id_worktable').append('<img id="logo_easytomepro" alt="logo" style="width: 200px;" />');
      logo_base = "data:image/png;base64,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";
      logo = $('#logo_easytomepro').attr('src', logo_base);
  };

    $.fn.intelligenttimeFillHead = function () {
    $('#id_worktable').append('<img id="logo_intelligenttime" alt="logo" style="width: 200px;" />');
      logo_base = "data:image/png;base64,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";
      logo = $('#logo_intelligenttime').attr('src', logo_base);
  };

  $.fn.wdmsFillHead = function () {
    $('#id_worktable').append('<img id="logo_wdms" alt="logo" style="width: 200px;" />');
      logo_base = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAC4oAAAKSCAYAAAAuvMT/AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAznBJREFUeNrs3Uty09jbB2C5q+f/9AravQLCCuwUlTFhBTgrAKZkAAzcU8IKYlZAGLu6Iq+AsALcK2h/K8h33lhuTBpCLrKsy/NUnRJXxz7nSNblp1dZBgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADN09MFAAAAAAAAAAAAQB0czfb7adH/3t+NB9NcDwHcnKA4AAAAAAAAAAAAsDFr4e/d1HZS+z37GgZf/dldzIsWzlP7v2K5ECoHEBQHAAAAAAAAAAAASnI02x9my/D3g2wZBh9u8e0ssmVwfJYtA+X5eDCdGyWgKwTFAQAAAAAAAAAAgFs7mu1HJfBhaoNiuduAtx3h8Ty1z6mdjgfTcyMJtJWgOAAAAAAAAAAAAHAjR7P9CIM/zZoTDP+ZVXD8Y6biONAyguIAAAAAAAAAAADADx3N9g/S4nFqsdxp+ceNCuPvs2W18bnRB5pMUBwAAAAAAAAAAAD4RlE5/FnWjXD4jwiNA40mKA4AAAAAAAAAAABEODwC4aNsGRDv65FvnKb2fjyYnuoKoCkExQEAAAAAAAAAAKDDjmb7w7R4mi1D4lxvni2rjB+PB9OF7gDqTFAcAAAAAAAAAAAAOuhotn+QLauHD/XGnUxSezMeTOe6AqgjQXEAAAAAAAAAAADokKPZ/igtXqXW1xulmGQC40ANCYoDAAAAAAAAAABABwiIb9wkExgHakRQHAAAAAAAAAAAAFrsaLY/TIu3qe3qjUqcpvZuPJjmugLYJkFxAAAAAAAAAAAAaKGj2X4/LU5SG+qNrchTO1RhHNgWQXEAAAAAAAAAAABokaPZ/k5aPE/tld6ohUlqbwTGgaoJigMAAAAAAAAAAEBLHM32D9LibWp9vVEri9TejQfT17oCqIqgOAAAAAAAAAAAADRcUUX8JLUDvVFr89QOx4NpriuATRMUBwAAAAAAAAAAgAYrqohHSHxHbzTGabYMjC90BbApguIAAAAAAAAAAADQQEUV8VepPW/YW8+L5axYzou2cv69AHX6vLvZt2H4YbH8PbX+WmuK+IwRFj81m4FNEBQHAAAAAAAAAACAhilC01FFfLfGb3Oe2nlqn7NlOHw+HkznFfTNMFsGxh8U/TOs+XCqLg5shKA4AAAAAAAAAAAANMjRbH+UFm+zb6tr18E8WwbCo1J4XkUo/BZ9NsyWgfFBVs/guOriQOkExQEAAAAAAAAAAKAhjmb7UUV8VKO3lKf2MbXTOgXDb9CPB2nxOLVY1ilwf5z68YWZDpRBUBwAAAAAAAAAAABq7mi2H2Hms9R2a/B2zlN7ly3D4YsW9G3dQuPRv0+aFLwH6klQHAAAAAAAAAAAAGrsaLYf4fAIiW8zxDxP7X1qkzYHmFNfj9LiaWrDLb+VCOAfpr4+tQYAdyUoDgAAAAAAAAAAADV1NNsfpsWHbHsh8Ty19+PBdNKxfu+nxats+1XG36S+f13xZ99Zfe70s4+thdBcguIAAAAAAAAAAABQQ0V165Mt/fhJau/Gg+l5x8cgQtPPU3uWbS8wHlXFo7r4YsOfM8Lhj4tlqDykDpRLUBwAAAAAAAAAAABqZosh8Um2DAjPjcI347HtwHiExJ+kcclL/lzr4fCrn2uv7J8HVEtQHAAAAAAAAAAAAGrkaLYfgeS3Ff/YPFtWrZ4bgWvHZpuB8fNijM7v+RmuC4f/K/0cGVNoOCsxAAAAAAAAAAAA1MTRbD+qiI8q/JEROn6hcvStxykC1m8rHqsQlcX3bhsWT+93Ny2eZstweP8m8yL9jIdGGppNUBwAAAAAAAAAAABq4Gi2H8Hj5xX9uAgcvxkPpsd6/l5jNkyLCPf3K/yxNwqL3yEcvm6SXv/QCEOzCYoDAAAAAAAAAADAlh3N9kfZMnBchdPUDseD6ULPlzJ226gu/t2weHov/WwZDH+W3S+8/sJNBNB8guIAAAAAAAAAAACwRRWGxCNcHAHxU72+sXGMwPhORT/yMixeLCMcHtXDd0t67Qih50YVmk1QHAAAAAAAAAAAALakwpC4KuLVjGcEtT9k96vmvXVpnsiXQgv8ogsAAAAAAAAAAACgekWoeNMh8QiGvxgPpk+ExDcv9fF5WjxM7bzBH+PcSEI7CIoDAAAAAAAAAABAxYqQ+NmGf8w8tb3xYHqsx6tTBPL3Ups09CMIikNLCIoDAAAAAAAAAABAhY5m+zvZspL4zgZ/TJ7aw6LCNRWLsHhqh1kzw+KfjSC0g6A4AAAAAAAAAAAAVOtDarsbfP3j8WC6V1S2ZosaGhbPjRy0Q08XAAAAAAAAAAAAQDWOZvtv0+L5Bn/E4Xgwnejp2o37WVoMm/Be0/yRLYWWUFEcAAAAAAAAAAAAKnA02z/INhcSj+rhQuL19SS1eQPeZ26ooD0ExQEAAAAAAAAAAGDDjmb7/bQ42dDLR0h8T0i81nayZoSwzw0VtMevugAAAAAAAAAAAAA27kO2DAuXbRUSF/CtmaPZfox3VJF/ltpuQ972ZyMH7SEoDgAAAAAAAAAAABt0NNt/nW0mKCwkXr+xXoXDHxfLpjGXoEV6ugAAAAAAAAAAAAA242i2HwHxTxt4aSHxeo3zKGtuOPxfaT7JlUKLqCgOAAAAAAAAAAAAG1BUl/6woZcXEt/++K5XDt9pwUfKjSq0i6A4AAAAAAAAAAAAbMar1PobeN1DIfHtOJrtD9PiadaecPg6cwpaRlAcAAAAAAAAAAAASnY0299Ni+cbeOkIiU/0cOVjuQqH91v8UT8bbWgXQXEAAAAAAAAAAAAo38kGXnMiJF6NDoXD16koDi3T0wUAAAAAAAAAAABQnqPZflQSf1vyy56PB9OHenfjYxcB8Qj573bsoy/S/PrNDIB2+UUXAAAAAAAAAAAAQDmOZvs7afGq5JddpLandzdvPJhGVe2PHfzoqolDCwmKAwAAAAAAAAAAQHmikvhOya+5Nx5MF7q2GqmvX6fFYcc+9szIQ/sIigMAAAAAAAAAAEAJjmb7/bQYlfyyb4oq11Qo9fkkLR5my2ruXWCOQQsJigMAAAAAAAAAAEA5Tkp+vbyobs0WFAH9vawbIWpBcWghQXEAAAAAAAAAAAC4p6PZ/jAthiW+ZFSyPtSz27UWFs9b/DEX6XPOjTa0j6A4AAAAAAAAAAAA3N+rkl/vjfBuPaRxiCB1hMUnLf2IqolDSwmKAwAAAAAAAAAAwD1soJp4Ph5Mj/VsvaQxiQrvL1r40QTFoaUExQEAAAAAAAAAAOB+yqwmvkjtUJfWUxHgPyzGqS0+G1loJ0FxAAAAAAAAAAAAuKOj2f5uVm418XfjwXSuZ+srjc8kLfay9oTFVRSHlhIUBwAAAAAAAAAAgLt7VuJrzceD6WtdWn9pnCJc/TBrQci6+CxAC/2qCwAAAAAAAAAAAOD2jmb7/bQYlfiSL/TpZYX2neK3izqHmKPye3q/UVn8Q1ZuVfkq5dZkaC9BcQAAAAAAAAAAALibUYmvlY8H09OuduTRbH+YFiep9a/8+TwtntQ1MJ7e1yIt9tL7PCl5PlRlbjWG9vpFFwAAAAAAAAAAAMCdPCvxtd50tROLKuJn2ZWQeCH+7Kz4N7U1HkwPs2ZWhP9sNYb2EhQHAAAAAAAAAACAWzqa7Y/SYqekl4tq4nmHu/PtT/4++vlV3T9EGsPjtIjA+KJBfX9ubYb2EhQHAAAAAAAAAACA23tc4mu96XhfDm/wbw6a8EHGg+kkLfayhoTFO36DArSeoDgAAAAAAAAAAADcwtFsv5+VF1zOhXXbJY1nVOl+mNW/WvfcaEG7CYoDAAAAAAAAAADA7ZRZ3fqN7myf8WA6z5aVxfMav81zIwXtJigOAAAAAAAAAAAAt/O0pNeZqybeXmlsF6lFWHxS07f42ShBuwmKAwAAAAAAAAAAwA0dzfb7abFb0supJt4B48H0MC1e1PCt5UYH2k1QHAAAAAAAAAAAAG7uoKTXWaR2qju7YTyYHqfFYTHudTE3MtBuguIAAAAAAAAAAABwc09Lep3T8WC60J3dkcZ7khZ7WT3C4ov0fuZGBdpNUBwAAAAAAAAAAABu4Gi2v5MWuyW93Ds92j3jwfQ8LR6mdr7lt3JuNKD9BMUBAAAAAAAAAADgZg5Kep15ERimg4pK3lFZPN/i25gZCWg/QXEAAAAAAAAAAAC4mUFJr3OqK7ttPJguUouw+GRLb8GNCtABguIAAAAAAAAAAABwM2VVFH+vKwnjwfQwLV5U/GMXqc31PrSfoDgAAAAAAAAAAAD8xNFsfzctdkp4qfl4MFXNmX+l+XCcFhEYX1T4M81B6ABBcQAAAAAAAAAAAPi5YUmvc6oruWo8mE7SYi+rJiye63HoBkFxAAAAAAAAAAAA+LkHJb3OR13J9xRVvh+mtulq33O9Dd0gKA4AAAAAAAAAAAA/NyzjRcaDaa4ruWZ+zLNlZfFNzpOZnoZuEBQHAAAAAAAAAACAaxzN9nfSol/CS53qTX5mPJguUouw+GQDLz9PbaGXoRsExQEAAAAAAAAAAOB6uyW9zmddyU2NB9PDtHixgdfN9S50g6A4AAAAAAAAAAAAXG9Y0uvkupLbGA+mx2kRgfGyqoCf61XoDkFxAAAAAAAAAAAAuN7vZbyISs7ccd5M0mIvKycsrqo9dIigOAAAAAAAAAAAAFyvX8JrqOTMnY0H05g/D0uYR+YhdIigOAAAAAAAAAAAAFxvWMJrCOhyL+PBdJ4tK4vnd3yJ+H8LPQndISgOAAAAAAAAAAAAP3A0298p6aU+603uazyYLlKLsPjkDv895rIbFqBDBMUBAAAAAAAAAADgx3ZLeh0BXUozHkwP0+LFLf/bPILmeg+6Q1AcAAAAAAAAAAAAfqysiuJzXUmZxoPpcVpEYPym4W9V7aFjBMUBAAAAAAAAAADgx0qpKD4eTOe6krKleTVJi73sZmHxXI9BtwiKAwAAAAAAAAAAwGad6wI2ZTyYxvx6+JN5lmflVccHGkJQHAAAAAAAAAAAAH7sQQmvsdCNbFJRsT4qi+fX/DM3LEDHCIoDAAAAAAAAAADAj5VRhXmuG9m08WC6SC3C4pPv/PWiCJMDHSIoDgAAAAAAAAAAAJv1ty6gKuPB9DAtDq/88Uc9A90jKA4AAAAAAAAAAADQIuPBdJIWT1JbrDWgYwTFAQAAAAAAAAAA4Md2dQFNNB5MT9NiL7Vcb0A3CYoDAAAAAAAAAADAj+2U8Bq5bry/o9n+jl64nfFgep4Wh5mK4tBJguIAAAAAAAAAAADAVtwy/P0l/fvneu12xoPpIrVcT0D3CIoDAAAAAAAAAAAAlTua7e+mxZdb/JcIlb9N/+9E7wH83K+6AAAAAAAAAAAAoLmOZvvDtd8Ov/NPHmTLgO2PzH7w5+epLYpfR0Xic71NifM2QuJnP5mbPzJK/z8qZR/qSYAfExQHAAAAAAAAAACosSIIHmHaCNb+nlp/rZVheMP3sfrlvGgRIv9c/FmeCZNz8zkd8/kku1tIfCXC4n+nOfdajwJ8n6A4AFToZf5od+0gZ/fKAc/vdzyIj4Pvv9d+HwfiqwPvxZ/DvxyEAwAAAACNcqUi5neNB9NcTwEALdwPWoXBY38oqoD3i9/XTT/7en37oFi+Kj5DLOZFmxXLcwFyrnhe0tx+lubcJM2vuS4F+C9BcQAo0VoQPA7a/5d9DYPvbvE9rX65eiRYLP8vK+7mFiQHAAAAAG6ieCz8evGLfvbf4hcPsu9XBPzev73v+7nJP1udF103W/v1N4U3hJcAgC3sY8U+0jC1Qba8rrzbko+22v8bXtl/y4v9r6hCLjzebc9Kep04/hil9lqXAvxXTxcAwO29zB/11w7S63wX903N1w/Go/05/GtupAEAAJplrepY3cSF34URMqdKIsjZ3Pl0NWS8bfMuV5y7Mh7Dtb9aD3r3s5LD3Q0yL1pYBcv/Lcbhew3f45vjaQFYJ6wTHZmPUYE7guEHHd7f+vcYL1uGx2OfK6/r8V4as4sSXmbPOv1vf8YxyFnJx3d/6FmA/1JRHABu4GX+KA5ShtnXu7h3WvYR+0U7WPvMq0o6s+LAPMLjLn4AAADUWxyvntXwfT1J7dTwNFKcKzip4ftSCKeZzrJ6nVeLbdO8bZ28FgDvZ19DR4Niuf5nXG+9r4bf6edY5Nky2PQ5+xosFyKnTnZrum/4s+3YQzeF0bF9W/u+HVDcqBBz8HGxb7GjV/616puDoq8WxTmEuE59WqN9q/Ps/jebDIt9SL6zj33f/fdYz+yLA/yXoDgAfEcRDH9cHOgNO9oNO8Vnj/aq6JfzbO1ubsFxKNfFxcXV7U1Z259vHrHc6/VyvQ1bW8+vVi0alrh+L9L67SIqQMdFZdyj2f48q18IMAKKguLNNKjjm4rKY6qwNUsNq4mHvIH9uDqmWC3/t3aMMTTTKrfq84Mr47RehCO+l8+FXuFWnhbrEJTtmS5gC/tvB8V27UBv3Fjs646KdpL6MPbbP2bL0Ph8i+/LtfFy/W8Dr7mbCeID/IegOABklwHofnFwPnCQ/tMDq2jPi35bHZRHaNxJW/iBi4uL9Qu4sfw9u6YiVQXvZ/XL1UXLsHqEcqzXwqZw9/VrZ+37cif7GqyqJBSztn6vAuTz1P7O1irbpfXbyWyA9ot9ulHN3tPQsDTWsMbvKzc85tJ9tpV1rTS3Fqpf9dlg7bwCzbBehGM1rqvv6DheiwrkwuPwY3Gd5oVuoOTv177vUiqeb8+KY3OVw8s5loj2NvVt7D+9T22icnTjbWKb/CHNkShU8M6+NsBXguIAdNbL/FEceDwtDiqdGLrfQXn05zxbVod7LzROF10Jh/5eLPtZvR/nvH7RebV8VXyeWMS6HOt2XLzM49e9Xm9utOHf9X61zj/Ivg2H18HuNe87W63Txfp97kkDAK0TNwGOavaedj3+t3mKsGpdj2keGKHGqVt1+o81WteiKMPjBpxH4P6G2bfh8fXK47knJVDl+YGa68d+iIAXJWtsNXHrQ6PGKo7Fn2Zult70d1u0t0Ug+H1aP5r0BDPHsl/NNrCu/FuNvnji3io0PtfdQJcJigPQKUXl8DgRFNUo+nqkVNGfcVHrudA4bXdxcRHzfXUiapDVKxxaptVnjG3mKkAe6/fqAqZwKV1b94fZ8qRlG9b74ZXPFotYv2Odvrw5xJMFABqtrvtoHv/b8H0G7417qttT/Oq0PXpsTnfWeuXxV2tVx+O8y6lQICXNsaaKazmHhpAW74t0ZV1uvbgpOlsGU2O71dcjla/XB0UgOKqMH2/4BvUygs3W5682XUwg1sfL/MJaJfpToXGgiwTFAWi9l/mj1cF53L2tcng1/j3oKkLjl4//+nP4l4MuGmetUvgwa3co/Dbrd7SDon9iETeGXFa+EiylZev/aq4PsmZfSLrN+j1a+/yxyNfW79ysAGiGuOBVXCTt1+ytDTNB8aYZ1Pi97ais2BxprIY1e0tzc4caG2Zfg+OL4rszKuCfejIHHRPnYgTFKXNfpK8nKHlexbWiuB4aAXHh3+2K9ftVsf80Scs3NQ4D2xZ9lVf4s65Word/DXTKL7oAgLZ6mT8apnaSfvlP7PBnQuLbPjD/ksbjLLWRLqHOIhie2kFqb1P7VGxDzop5PMyc7Pueg2I7+yn12ZfUTqIPdQsN3QbsFuv/l/juKuZ2l+fzsNj+naU++Se1D6mNihA9APVWx8cuDwxLI/cFvD/aOFa5IaEhdopj0svz3Eez/U+pRUVEx2Tc1P+aPP/TXHeOkbI81QWUJQLiqb3OluePX2WuG9XNKMYmjdHJBvaZ5iW8hv24QnHz7nwLP3q1f72aJ/Y3gNZTURyAVlmrHu7RXvU0jJbGKUJ37zJVxqmJi4uLmJurxzy7qeR++sV2OIKkcRf+5V35vV7vVNdQ423Aat4+tf9wrVVAYfVEgTiJm6f2vs1PE0if83nxHdEGb1SG5xb7Rq8a/jEWab4/6fhQxhMhntfwmJCGKKou1j3wEDcfHButRqjbjSIfDQkNtV4JMY7D4kmOpzWumEk95kyTxfG484rcd792dU6r6etybjRrMZ9G2fKcSV9v1F6M1ajkCuPzkuZR3/7bv95ky9D2NuyszZO4phlz5b2nTwFtJCgOQCu8zB/FwfizYkfeXdv1F2N0+fivNHZxwPXuz+FfDrioTFQNz5YnhlfhcNuNza3rsV2O0Pg8W17Uedfr9ea6hppsC2J+Ps2E1u5qFVB4vraOtzE0nmfLyvJtMM9cVORm2rBtnBjGeq7vET4eD6a2Rc3QhO2AG30boAhn1W0+2Q7RpmMyoXHa7CDN7xdpXi90BfeZR1nzrwG4hlGDY9ns65NnaZZRtgwCx03Gb+75nVLWflY/204l7dpJ4zFJY1OHc5GxnY2CC/H0nnmxbz2xbw20xS+6AIAmi4B4apePBSp23J0oaebB+ac0jmepDXUHmxIVg6MqbGpn6bf/ZMu709twgrgp+sV2+kuMQWoe48Y2twVvU1ttB3z3lLuOf0p9+6XY3vbb8MGK4Htbwu8Hxc1S8NO50oLP8L7rg1hc+Kzj9kuwtzkGDXiP/Q08Spzy1W2f+1zgkBa6DIyn9iVtFz+k5rwLbdGGStBs32NdwF3FTY+pxXfsWeZcctON7vsCJYaGzaVvxVMB63QOq58tbwyJfetP8SSB4gZogMYSFAegkSJQHMHibBkQH+mRVogD4jOBccoUYbgirPip2F68zZx8qcv6/qEIk46EFqloe7CbmpvLqtEvtrexjn9oyY0h71oyNi6wc5PtZRtupJv3er3caF6qYz8MDEuj9tu9T9q43n80JLRc7M9FWPyf1F67ocYxegs+g5Avd1ZsA50L4a7zJ+bO6nwyzXda0g2jZQSafzccXxXjspfV8zxW3JAZ15b+KW7IHBkxoIkExQFolJf5o90iIO6u7faKcRUY516K8PGHbFk5/G2mamFd9bPlyZUIk74WGGdD24Nh8SSBuGFkpEcqdxlQKG4MafJ6fppaW6pOPjUt+Yk2hDDeGcZ/zWp6zEfNNawSrZsP6q9u6/2pIaEj4vhrVQkxQi2+g7up34LPcKCKJ/eZPy35HA8MZaXHQ1FFPK4xfcgUHGmTsm4YnZfwGq5bXhFh8dQiLP4iu9m5+DxbhssPs+oC5vGdclLckHniKT5Ak/yqCwBogpf5o362PKk90hudMYyWxj4O7N78Ofwr1yVcJ6oFp8Wz4iDdibtmWV24fJbGMYJdx71ez2PAKWOb4CkC9bHal3uVxmYS3+1pPZ835c3HNim979OW7IvGzRP9JvU/lWvDBQ4BwK/qeBwVF9x3x4PpueGptSaFr+3v1VgR7KtTCGJh+0OH9/EibBvz/11aDya6hAbOYfOWu3jWks/hmkd1+69xfBEFbvp6o1XiOKCs80Wfs/ufPxMU/4E0TsdpcVyEsAff6asoinB65bhusvYEiacV9G9sk0fR0s+dZ8tzke8dawJ11tMFANTZy/zRKjzokV7kqR3+OfxrritYF9XDs+XJXidV2iPW8wiRTnQFd9gm9DM3lzVFnDx9l9b1vCFzK75nPrWk72Mb+9oU5Dvz/PIpAE3ftqT5/cRofnU02/9Uw33lQwE186Zkf6Q55XxBPedS3b5bJmmuHNawnzw9karFNvNNtgzZuFm/3dvhi5Z8lPM0Vx8aUW45/9t0LicvKu2y2TnzOlueW6Z9SjsOKPEYZy+9p9zQbGz7H4HxGKt+lfsrqb0v9rHnRgKok190AQB19TJ/FOHwL5mQOEvDmA9pXrwtbiCgwyIImtrb1P7JlpUdhMTbpR/jmsb3LLWh7uAW24bX2fLiz0hvNEKcpD1ryrre6/XiJG9bKoI8Nf34gcct+AwfDeN/5DV8TwPDUl81rAB9E44Jfbfc1MyQwKV+tjyn9iVCccW2n/Z9pw9b9HF2i0qhcBvOf3DjY6DUIvgrJN5eZZ4vKusc8dCwbEZU9k7tRWp/pN9GQYlJalXcHLl60m3sY5+lNrKfDdSFoDgAtfMyfzRM7VOxE23HmasubyBIc2SkK7onqrmmdnkRq5gLthHtNsyWIdK4KcBYc922YZhabBde2S40el0/KSrC19m7lvR5v6iQDlcdNPz9LzyR5LvqGIocGhbbgpK5+aDe+3p1cmpI4BurJ3p+iiCL7sA+Ci3Tpu2a8zgbUlQePrONabXFeDAt7TigqBRdRujYcWwFYuyjmnxqv6XfHlZ4TBjHwnFN+5+0nTkpKtEDbI2gOAC1EVWiUzspDsad8OA6cQHjJM2Xs9TMlQ4oQqCxbVApuJsubxBJc8BJFK5uG3biRoJi36GvRxpvVKzrtb05pAigtuWx7M9MOa5sUw+y5t9sMzGS35XX8D31VYSstSZerB4atvop1vM6retRVW5hZOD7382pRYDli8A4NaY6NLfZD2nDMe46xTE2M0/iOMJ16fbbRDC4jKrijmMrlo4HJ6lFhfEIjb/IqnuCaOxff0jbnFVo3DYHqJygOAC18DJ/FCdsvmQCoNz+APpTmj9v40YD3dE+awHxs8wJk66LdfxDUXHY+s7l9iFb3jzyXG+0TozpSY3f36Ql/ezmG6563ILP8N4w/lcRijyv4VtzUazex9pNs+txzubSDXw0JPBT/WwZGD8rwnM0fzzbZFewiltwYwHXKm6MimtPjiPabxPHAbOS5qFztFsQ58pSO07tYfrtH6m9SW1ewY+O7U1sez4VN2i+VUgBqIqgOABb9TJ/1I+q0OmXHxyIcw8RKIvA+FBXtIOAONcYxfqe5oeLQt3eRqgi3n51DvG8a0kfR0X+kanGmqZfmDrv9XrnhvGH8hq+J49YrqEaVoC+DceO1vOfOTUkcKtt6llR8dB5++bqt/AzCf9yk33ancwN8lw/R0ZZvQtVUJ4IBG/iOCBv6TFT56T5MU/tdWoRGI/g+HFWzVNFYz/t8onKxU2arnsCGyUoDsDWvMwfxUF4VAId6g1KOpg6U1282S4uLvoC4txwfY+wuErS3dxGqCLeDbUN8fR6vXlWz8DlXTw21Si2r214JPc7I3mtWQ3fk/39emryuLjAXj91CmhFQMQNRXB7o2wZXnEcju8WzJMtEyIsrR/ju01IvDs2cp45HVvktlftE8eMqb1I7bf02ydZdU8XHWbLmzT7RgHYFEFxACoXId7UPhQH4QK9lG1VXdwJswa5uLiIqqaxTfiSCYxwc29j3sT80RWd2E7EtiFC4rbv7Xfa6/UWNX+P71vS1wdxA4YpR9aOmwZUib1eXsP35Dvd9sCcarEiyFSnYzXfE3B3sS6/VemQmuibh9zAsxZvj7nfPuooExLvmk2ex819r7VXVKJP7TD9MkLjhxUcU17uc+t5YFMExQGo1Mv80TBbBkHdHcsm9bNlWPy1rqi/oip0bBdGeoM7iHlzJize+u3E5ThnLoZ0xce6v8FerzfJqnn8ZBXsl9OGeTBpwA0mWzUeTKN/aldJ92i2PzQ6tTP03mnpeMwMCZSyXn9K39+vdUVjPGjp53pqaLnmGKOfuYGQ78+NUSYk3jXzEit/b/IYw/dajcU5tdQmqUWF8T9Se5Ft7hybc/XAxgiKA1CZl/mjuANSyIsqvUrz7iy1vq6on6gOnFpUB35ru8A9xYn/L2k+uQDQzm1FnLx3Ar9bmlLtcdKS/n5mynV+O3vQgn2xj0byRvIavqehYamPGlaAvstnMKfqY2AfE1rrVdrefirCmNRbW8+5jgwt5ge3PE6IeeEcc/ecNuT1hYMbYjyYxs0Hx6k9zJah8ePU5noGaAJBcQA2LkK6qUUY9LneYAuG2bK6uIPsmojKz6mtbhwR7KUsceHrTFi8dduKOHk/0hudctqgqsDvWtLnfdvOznvc8Pc/T9sN4b+bqWOgfmBYanf87DPQxrE4L56sAJQnjiE+FcE7qNpOmnvO9/Mjba7M6/zNHRTbCyHxbnq/yRdPxxhRVXpewkv1ixu3aZAiNP4itQiM72XLwjL3Pe6c61lgU37VBQBs0sv80TAtPmSqBbNdMf8+pPl4/Ofwrxe6Y+vipJwbR9jUuh5h8Re9Xm+iO5orQuKZm0m6qjFVgdN2Zp7map61I5AWF1HPTb/Obm9HDf8Y743kzcTjlo9m+3V7W0MjUyuPW/AZ3HxQAzWsTp8bFdiIWM9P0jof3x+Hbsio7Ri1eb/FDaNc3QeJ44u+dZor+6VdDonH+b7Fld//3w/+7f+y/56Pb/Ix+7wIcldxrDEq4XXiqY+H1tpminNuxVw4LG5OifPtd7mpzb4NsDGC4gBszMv80eu0eKUnqJHnaV7GSY4nfw7/cuFie+IgV/UGNuXyIuXFxUUmLN5MQuKdtsiadyI0AqrDFvT9KDU303VTG6rw+b6/nbxu2624cF/RxVt+bugz0NLvl4+GpPHfXTdRtxsUurbO76bv9Ce+02tnt+XzTqCOq57qAtaONS+LSHVg/yD2leap/b3abypCq2X35e6VY65B0bd1/a6p6jxzHGuMyvheS/38wo13zZfGMObeabHerELjwxv+93d6ENgUQXEASvcyf3QZ0svaETqgfeJA7FOapxEWd+FiC3q93uLi4uLUNoINExZvICHxzjuN74iGfadN0rx9mzX/gtNO+hwH6fOoWNI9Ta8enEd1f8N4K7OsfkHaeD+OzbasqL7Yms9SdjCCW6tTZfeF+bC97+nVGKT2ee3Pr1a2jGqP8w1uE/rZt9Vlh9+Zq0Lm9xd9fFYEnCa6gyqOY9N8G5lvXOGaA+s+ZO2rML8o9rHi2D6v6gatIrycX9nHW9/f2i32p/rF/lUd9q3eV9Q3EQhelPB5V6Fi32stUaw3MZ6T4pgkxvfZNdulw00eFwEIigNQqpf5o35x4C3gRZ3FPD1L8/Xwz+FfAlHb8TFz0pbNi7D4ea/XEzxqACFxsuZWepyk9rwF/R+VTewXdW+72/T9sfdG8tbyrH5P/oqLyMeGZuuGLfosu9nNKxDT/vlkLmzGvGhxvP1/2dfw97xu4Ybi/cxvMifWQuWrcFPdK2XWzWUBmdSPD1K/e2IRVXicCdTxdRs+ytp/088DI33j+fC6Rcc4sR8T5+ze1/XJHcX7Or8yBqvw+KAYi36VfVZxX8X4jEp4nVe+19qpOCaJc1/HxbrxdO0YY16s345dgY3q6QIAyvIyfxQ7sxHwUn2FJomwuIPuihXBpC+2F1QgLlTvCYs3YrvwKXPxvdPralpPf2vo3O0X32lt8FvTqrpzr7k7ypZPgrLd6Jij2f5F3cZyPJgay+3Pizbti52mOfXEqG5tLg2z5fnBujhsQrXZ1G/RZ8MavrV5tgz9fC6W87oGlCoYozpWyqz1trhY/xxfbHfOfurAR/3NPKOY81HEqu3FaaKC9J7Rbtz+6J2Ok7NlYPh9W/a9ihvyYmweF8tN7kcdV3nTWslzbk9gGIBNUFEcgFK8zB+N0uJt5uQ4zXOS5u+DP4d/qXJToQihXVxclHWHPVznskp1mm8P07yb6456SuMTQUUh8W5rbCXr2LakOZxn7ahSFN/Lqvp2x2Pbjc6q2zZrJy4Ye7zu9qT+b1u13KFR9f1yZZvH7fvsTWrnwpdf/aBSZr/Y5jwolo5rv4qwZj/10Z55tL19rA7NtYnh7vz+bD/zBFO+Htt8aPBHiH2Nd0240fEO+1LzYns9KcYq1tnBap+h5B/3vuLPlqfPMy/pc7xyDAPAJvyiCwC4ryIkHgEvIXGa6nmaxye6oXIfdQEVuTw5XFSyp2bSuMSNZiM94Tuh4e//fUvG4amp2Jltb3wnNv0i+jsjeWezGr6noWHR/2Xu/xdVVDGfzt2EcrfviQi7CPf+XMyvCHJFxcrUHqY/iidkxBMN4uZLc28ZnP9im4zjWCogJM5KU69X59mykvTDNobEf7AfdVrsQ/2RfvuwxP2nbT0Bp6zzw8OiQjkAlEpQHIB7KcK1Ara0wSjmc2qCpBXp9XpRBdJFR6qy6/uqfi4uLkZp8VxPdN6i+E5o8nfapCXfabtpveybkp3Q9Ivo52m9OzeMd5bX8D0NDIv+L9nQsFavhtXpc6NClSJcfyX0FO0w6/aTUC6f9CYszia/84tq0nRbV24YsC29fl80znU07XzHPFsGxKN1dt81gt1r+09x093kHi+3rYIekxJf65U1GoCyCYoDcGdFSHykJ2iRmM9nwuKVOtUFVOjg4uLitW6ohzQWcWHjrZ6gRd8Fk5Z8jmemZCc8bvj7f28I766mF5+HRma7+8kt/ExuPrAuB08yY9vfuauK4xF4WlUbj+OGrhVOWIXFfd/bv7IvQ+mKG1G6EqB27erH8yD6pknnmmNf4DIY3eWA+A/2n+Kmu8Ni3+lFdvsq45Nt7fdl5Z3nVlUcgNIJigNwaxGiFRKnxeKEorB4dVy0pWqvLi4uXDzasjQGsY39kLm4wVJbAp/vWvI5bCO7sQ1u+jhPjOS95TV7P/3iwj4VKypw9lt6bE/16hTQXwjdUCdr1cYPU4vgU9cqja/C4iOzgQ14qguMP533qkHHNbGP+jDtDxwbtp/uOx0XVcb3brjfdF4EtrflfclzGgBKIygOwK0U4dmzTEicdhMWr0iv14sTOws9QcVOLi4u+rphu2OQtTOQxO3N03dB3pLvtHlWv+DlXfTdUNN6TR/f07S+2X+8v1kN39PQsOj3Mr/PihA83Z1PueGgzq5UGr9LtczGng8QFmcDdn3vd5ptSscV6//zhrzdqCK+t+UwcxP3m/JivylC45Nr/un7Lb/P0xL36aKquHO0AJRGUByAG1sLiavKRBcIi1fnVBd81zxbXti+2gSj7i/W6xPdsB0XFxejTMVi2vsd0Jbq6I9NzVZ7bD0jq2eAcmBY9HvJhoa3OkVAp07nDD3BjEb4TrXMSQc+trB4NX7f0s/dVoXcZ4a8k/sfcY6x6ms4b7a5rU6f2TXa73yvNOA9xnUdVcTvv980j6ezZMvA+HH23+tldTjX/KbE13pr1AEoi6A4ADciJE5HCYtXowthnzhZlWfLk1RvihbVD/aK9lvvv/5Ibe877T//du11DrOvJ6rzTKj8OsOLi4vnuqFaRSV3Jze/3S7ka9uFVTtcW6+ffOfv3xTbk9X/9x1QE2mTPGnJtneU1lf7P+3cDse4NvlmnXnxRBruKapx1XH/zMjo95K5+aDbcyk3JDTx+3kt/PQma/d5HWHxzet37DhfUYJu2saN0BFO/XuLn9n5mjXpu2TYgGOa8/huT9/x50astH2mCIy/yL6tMH5ek0rtZT5JOZ6U9dqIA1CGX3UBAD8jJE7HrcLie38O/xK63YBer5dfXFzMs+1dvChTfI442fe5WC7i81XRhz/6uyIQFvN4mNqDYulk8tKr1D+nqf/muqIyJx2df+fr24Y7bBduFIpM83n3/9m7v6S4ce7h4/Jbv/uHZwXjWUHICtopims6K0izgsAtXIRckFtgBXRWALmmUnGvIMwK4lnB8KzArw6ICSE09B/bOkf6fqpcyTzPDMiSLEv20XGoX7nO/xOu/U3FdS4Bnym+IJk6O5+7fc7Y5ZHNMDfWgycIEu9W7XS9UOeZw8BCNsIy4VOsaOVBaQrM1xIkAqwk9N8jP06fhrXF+0TX0hIs3ijdwIbV+++1b9cY80wJptskEDOruayMi5Oh11DyJQj/u/+gBdT4oLx8Mia9kX5DU/Vyz5F63fXX5Ecta9swRpx12Dff+583ZX0DAFgXGcUBAM8iSBy4RWbx/lkM+mncXQCdZC148yAL+Ft/HEm2yyGCxF/iy3AbrB7KJGX7r7vLsrDvCLaSa/qcy28YbdtOXD7BOjdhfJBs4PIVgNf+2PXHaZ/jggRdP7je9++/QhCu+fvM5LWiekp1DDpL5DzeMXIlaYfrCw/MtBUoZIPDcFKvbwkYK2nmLPtTTXMgBRJo5I8jl3aG8YuwcQnMM1nHYlkxNkJ/uZ9nUv1q1o+a1zQEiQ83Z9K28ey0w3mbvMfiK60AgLURKA4AmIsgceAXBIv367OBMspDPXm4cx/4+ecQgZ99kAzaodwSOF6Ec5pm2veqtm33uAT7FTLbp/4w8z44/DY4O4wPsmHkRsk1fxkCyN+E6/61i79h5HOKHSF8paBO4FRkfCwZwZIbiy1nFK/5CkjnNG7YqWiWQY0yOEeeaQ0gBORrmjfMaBWkJPGA8dt3EASLJzevirUmntDsWXmfUd9+qKTp/6U5mzhB4pnP3Vy3yQ7Gfq40pmYBAOsgUBwA8BzJssoDWuCnTUf24V5IFlx3l6FbEynP1P2aEXhfS+Bnx/Uv57Qr5+mPXYVt0bcPIXgOPdaxS/Mz2fdjhVw395tHaivj7qMNI2/c3WaYoa7/Joz9qUolCH7C8JWUMdcVHjoeXck4rG1eO6JlBlVlcI70qQzvMX58u6RJkOi9+2HA+DShU5PnBZJZnGcz6fTVOlZfIpAuD2GT2tDvL5uwhoqtpAfc9oFNxesZgsQhuswqLs6ZKwEA1kGgOADgSQf1lgTD8kAN+N04XB/onoYXufIATzLsvn6QMTy5wPB55Dz9MZVzd3dBo3UmfY9P9/UoZCROMWt744/dMFZMrY8TEuAeNsPI9S/ZxvsOGk864FP6hEsjyx+f7U6L5fa8cTqzX6dA23yPzeoDCZ9p3xi4rzURTrWitQehKSCf+wWSFwLGd8ParU7ktOTZwTcCoJhndmCHqs/ChDlG9t4rLZc8v3hLkDh6yCp+u7GOmgUArIpAcQDAb0IQ7ISaAOaaECzei1hBg/fB4X+GrOGniWe5XUgIGpVg8VwCxidt2xKY1I/Uxkt5wPtvgHii1//1E0HjXb/cmGbQ91M4x9KPjRXDmH1h047ltsxm414EM2Xl2QiZ4dC/KkJfayKc5yZBh0n2J0vjGtAbyWzrD3lus+vS2KjK1xw7ouTeF2s8JgFSHt5l1Kfx9Bg3UVo8CRJvaCWEudpRx+vgyvf/PWoWALAKAsUBAL84qLf2HEHiwCIkWJxrpUMhOLsZ6NfJ73kcHN7QCk+2y8OA8dTriKziHQsBplVCp3Qaxo1pTmNzCBr/r//Ht66bjSPXmYy5Z4mcB1nF02A9WOIzTdibWmGZKpplEKMIfW1Gn0pP2NyhKRifbJ/IzvHoStaofybS/8d+XDmiVdemYeNdrHmmbDwkWDz9uUcZYazVMsb+QS9Q+x771PeTmubBIx87/nknbLAHAKyCQHEAwL9C0CtBcsDizgkW71yfQUCSWWnqj9chEzDB4UsIAePy0vGjSyNL1VMqMud27kMi5yF9/k0ImL7JeBy4DBtHZCxYJ8v450zqS+4xdQKnwgv2NFgO+G9kHkIT9kMykSqc241omWHmvgP/vph9jZfoafWlZ+8ZZHBExvf0G3/I5t63zv5zmw8E+ibRJ2PO4dnwnLb3EX6npo04JV1A5TUuX/nYp2nwxP1w6rp/RnzBl7MAAMsiUBwAcOug3uKzjsBqJFi8oho6M+3hZ0pAgnyCV4LDd0PmcqzI19+R/+N1qNcUfaCVu5FQNvHrMH7UtOq/44AEbd5+lcHdbR5plvwROWV5TCEofsNfzxN6vunxuHS2gyTPaMXeabvHEdTbswjBdxK8eBNxDcHmg3zql2ziyF7IePuns79p9Zxsmcwz1zAmgC5pMTaSfKHa1axlNpWuGQkSx5D9o/THBdUKAFgGgeIAgPsg8W/UBLCyi3AdYU0h+2pXwQNTd5cBWDKIT3POAtxHO0m9uu4/macBWcW7k0L2pmkYQxg/nh4LbmTzSPjagGzIaRb4z65z+pqD3H9cGl9h2KHHm2Y9GyNBf/2bKStPeTjbLmmWXg0d2Hu/xot1T2R+n899ZkZzAP9mF5evQVkOWpMg33OCfVcW61l1rWhcJit9gvyYMAnjQ+y+jXg0PnOeRv6KAvTPzWRNfNr1OtePiXwpHgCwMALFASBzB/XW7QNXF+fBCpAKuX6++euppCo6sU72VQk8mLqf2cNrqrM/Ibt4Cp80foys4msK2Wsnxk9DgsR3ac2Fx4PpggHjnzOsnmkC5zAO1zVssrxx5zKnzSURaZwzVzRLUvV7GyQWXo5HcTjbpk9lUK8hkzKAn9eEBCTJRn+rz20k2JkAqNVoed8Tc57Jhuc0xWjXaz+ealqXlpn3AW2bQOQe+5FLEwtY5cucL9kLG2gAAHgRgeIAAAkSJxPy8OTBQe3usuN9DIcEVr154nj9qfpauLtPhr5Z4Pj46KjDcU2190oevl+EzRdYz+WK15T09/sA8YZqHIav68sw9qQULE5W8fW9N15+gsRXHxOm7i4Q4eOccSHH4J2zRM6DbGwGhQB/y+u9z7Ri/0Lwrra53IiW6UfIzDr0uPDweUSstRrz+/TrlSBxYP59/k9n99nwhAAo0/2vjrmG5Ss1Sc5jYzybeGpd2kSsijLjPrCp8PzPlG0kgN57ojx36eOdg3yBhee2Cd7z/HERxj0A6MT/UQUAkK+DeuvIEfDRN1n0yUN4yZ4lDwqaT9XXepUf5P+7xi328KleoO2r8Ff58w9392ClornWJos1ySz+xrfXDdWxGgnybtv22i0WvCD1LAF4p/6/o87jtdm1bzN56fjNpbP56IPjk6LrmBguO0Hi648JMh4f+XFBstedPOgPdY4becJ9rU5griUbQE7p4eZYXu/dhA1pGEatrL/wIiytcaF59PcyQhnYfJB+vc5oDuBpITDp9eFs+9zoev3El70mEG8p/1E2z4y1Hh6zjk3KJGIffuxvmiOKSmGZpjQLlpiT1X5OI/elvY5/tASLNzG/4oXO3b9vlY1v++FLQQCwFgLFASBTB/WWPCD7QE10rnF3D43k5VQdgrvVeRCsXj/qF5th0SEv+irHJ+xWcf9JVIIM1/PZvRwcIovijwSI6yDt0LatZBZPJVhcsoqXZKdfnq+3idPzieNl1QSJdzsuyP3Q9wnZ0HPu8s4M/NnZDxQvfVtuyuYgercp7wyXfUrzDUrWsKoCxSV7UghsQ7cGD+x99LJ6FumeWNH03QpZPTXVK5uLgJfH411/7f7l7p5dWrIR1pRvaMXF51KKyvIl4v1C1kMEVrG+XQeBl7rsKCvPlE1MWIF8iVOev5Qdz5W++XneG8asJNba54/mcrJpUp7l7PKcDMA6/h9VAAD5CcHA59REZ+RFlASV/fmp+irHrj+mWoPEn+PLfB3KLucg2YFf+2Pfxf2MnkUTf51xja1/Xc0zleutKIp9gsR1Ce0hL+1SeRDFhqrV7Bgtt9zr3tJ8vYwN1/547Y9pxnUg557CPes9PdoO2fDkbG/e+kwrDqpWWKaKZkmiXh/3rWj3Qz7ZnPQ12hCkAywmZCO0uEG68uP4ES3IPHNJsvmwpAnsC/O4GHO5S6X1kWu/1rZGPOPqxApzsZue5mL3weKse23f7+Z9AWhM+wJYF4HiAJCnc2c306cW98Hh//1UfX1rNTD8JSFw/DQEjUvw55SmxxBCFuf60f8swcdvJNsvWZ5Vt939Q64UAiLHbdtyv1xCqK+x0eK/ZfMJepbCy6MxzUh7DeSa7PXDChmntN0HR7RMt0JASTn09fzCPw+pohcke42STRxY7r4/dXcbpa2tgT8QHMM8cwUTWiEJsb6WNVNaH2VuHcCP/9rm8mSbxzr3xtrdZRbvGsHitse58xfmLZuhfZnbAFgJgeIAkJmDeuvE2c4qF5Ms+B8Hh2cTUObPtZZM4+4uy3hNd3jWNNQV1nOfRVKus/2QjZa+Z0AI7Erhc8CWg55jsVpfHwlIxBDzgxTGxbZtGRfteGe47GTlikPbXJtnF92rIvzOvx79cxPx/Nl8YL8/zTOjOYDlHI+uZIOFPLux9nz7hNZbSMk8M4l1EX6K8SziJoyVYO75FJ5bYN252FFP90eCxY3xbbWxQJD4w/Y99/8+c2IASyNQHAAyclBvyYOUPWpiKfKgfOqP15+qr69zCw5/SsgyLi8RCKh7GkHi3bkM19+fRVGcUh22hKDbFK6F97TmUnYMlrnxB2MMhhgXG5dGtkteshvQtm3pbAfZ8jI+Dm2BlhVNksRcrXn4D8ejq4Y+ZZ+8yNZ0nyGIC1j52rnf6G/peXflxyDecbysjPR7rxXOM0uC5czPO8aR+jTzC11eKStPTZOgA3194eU+WJyEHzbW1t/c8l9A2fP/7ffw3wPAQggUB4BMHNRbpf/jnJpYmCzK5JNPf0rQrwRHUyW/9CfpSzxc/R1B4h0qiuLGH7vyJ7Vhtg2nzn4G3c22bRnvFuDryWoG9o+MMxjQ5wTOYRyudyhvJ8tzasblaGptBVL4eXHrBq/P8EltLX1tg0Axu33J0tgFWGI0WPyDH89LWk+l/83532MH3LLh2bZYiSk0f7EkxzFQ0zy+CfdPYN15mMy/3va1/vXHhZ8zTahpnR4Eia86vsl/94NnZwAWRaA4AOTjPCwI8LyHAeJHuWcPf0oIEmdR+TuCxIGn7bu4n5fvAi+TFlMZLHMTNjQAg/D97TKBMdExF+Te1bPPNF8c4UW3tjGqomW6EQKkh34uNC94oqFPmafpS0JfaA6gkznAW0NFlvvZCS1nqo81ke//ZFS1O4eV630S6ddrziheZtgPNJ1zzdWJDu+R0p/2e/wV5/4aYt6kb1y7DfJ262+Cuc8ezxd3ALyIQHEAyMBBvSUTw4qaeBYB4ov1JYLEn0aQODBHyAhq/frgZdJidgyW+SPNhghSCIJlA41ibduWzu7Xf2QDT00rRqWt/kc0SWeqCL9zXqD43xHr4RVdwWx/sjJuASaFICVLz2/GZE98muJ6iTlel75eeL5nU6x2uwyZfqGDtmccf9Ek6Hgedur6/Trvnr8PXoRNF4g/V5u4u0ziXbbHCW0M4CUEigNA4g7qrdL/8YGaeJYsvggQf7kvEST+NILEgReEgK+p4VMo27ataMkXWasjsokj2twhgXPY9OPiJk2pluU5O9nE49P2eXXGmu7E2NQ3L4CiZs5q1+Fsu3R6Mjo2IRMygA7460nWKvuGikx2TFtifwFihyYwKdZG9RlVr0qprDzMP9HHPGy357WybLz5HjJZI956WuavEnOx0VMbf6OWAcxDoDgApK+viWYKZLElAeL7BIg/jyDxuQgSBxYnLxotj7W8THpGyF5bGiv2JS2HGIqiaBLpf2QVp216mV/TfCrWyZps8BKzM1WE3zkvgCLmuqAMgc6w1ZesjFmAeQNktOzSZsjICOaZiyCjuDFhzhZr3qH9uc0fmXUHVfP38BUOoA9vXb8bEeRa+ubH1z2qevh7mj+++7/2Xff71DaAeQgUB4CEHdRbMtGsqInfyAvJt5+qr2/80VAdL/YjgsSfRpA4sISiKGTsPTN8CrxMep7FAK4zmg0RpZA1mXFRoZDpvTRa/MuwkQIRHY+upA20tUNFy6zncLZdRepP9Zz//Zo+ZdpIUVm+0BxAL+O3PPO0ki31g7/PkSjnVxtK+9VN5H4lGxBZx9oyifR7r8O6SLMys77wSlFZSDyGvu+Vb3ruZzJPOPH3xAvmUMMIGxslSLzv92i7bGQB8BwCxQEgUQf1ljwk+EBN/EayAEgWcbKILtaPCBJ/GkHiwAqKojhy+gKPFlWG4Ds8zVrdNAQjIvJ4eGl4PHw4LvKSXR/L2cQJ9tOjVlaeVzTJ2qoIv/N6zf+/TyO6xFo03f9rmgPozRsja5bS9Z+Z0ZqYz2he6jOx5/x8GYv17SI+U/XqaApmvaY50KeBgsXv13U/2ETVHwnEl4B8/9fzAcYxCRKfUusAnkOgOACk68QpzRwRyX0WcTnY7b0AgsTnIkgcWM9Hw2XnZdJ81oJt2DAGDVJ48bhDM6pj9eXOTVEUU5pPjZmy8lQ0icnxun7h/7+mT9lzONuW4EMtzxvrEEQBoAfh+nprpLjvyYipRrPm/KD39RJ9xdSco4z063luqA/XLXKbh8l6eYhgcbm2Lsgu3st9bOL/+OGGeVa7T5A4gEUQKA4ACTqot8aOT8E/VDuyiC/bhwgSfxpB4sCaQhBYY7T4FS04l7WM4jOaDBrmFQmcw6RtW14iKBG+fFEaLT5rNX1raE3Kw9l2SbOsJrzsjTFX++uF///vyH2K+5f9NRFfogB6FoKU9g0UVcZ0sorb6FMyz4y9yYd3Zza8j/R7G99PGwP1k9v6SNOz54bLEwPOw4YIFr+/N0p2ceZTa5LnV/745obJIi6mvq+cUvMAFkGgOAAk5qDekgnnCTXxr4+fqq9vyCK+VB8iSHzOQosgcaAzVrPobrZtW9J8vwpBotYCbWpaDrEVRdG4NIJjecmuh+UvX5zRfHqEwIhGWbEqWsZc3b2UMbymT5mk6UtCzOmBYeYFp0bWLWQV/+mV8vLFHr/5MpYNsZ41LDrexX7nWNJFovmbKsCA87Ahg8VvY0z8fOq7P1gvL0nmof6QGB3JIj5U/UmQOLELABZGoDgApGePBwS3ZMEkAeJHVMXiCBKfv9AiSBzolOXd7RXN9xtr2cRviqJgAxm0+JzAObynGdWwGrR/7cfla5pPnVpZeV7RJCuLEtgbXmg/p8mxXhKgZT3ULNDHAHRHnotqX0eTVfzXutAs9lfexmwq0M23zzhiP170OQ3zEABDrq2HChYX8r7nmx+LL/i628L3rSN3FyA+5Fx0nyBxAMsiUBwAEnJQb8lknUCNuwc0rz9VX2uqYqn+Q5D4/P60TzUA3QlBulOjxSeg5HelwXEd0DIeSqaqxvhp8LUFBXwbbDq7G4Y/04IqzZSVp6JJVhZjE0n90r8QMtfTpww5nG3LvUZLYF1NiwDD8WO2PMexEIhCVnEbNGSon9AMqsX6WhYb0QBonYvdB4sPuY6WZwk//NzqnIDxuWvkiT8kQPzDwGvl3fDVHwBYCoHiAJCWoSehGk3dXSbxhu6wOILE57oO/YnMs0D3rAaFVTTdb0pj5WVMB+Nh95hHxvfOcNmnNJ9KtbLybBL4tbzwMjfGXO3aQD+jTy1P05crvtAcwLCOR1cS3HupvJgbrE3+rQfNfalx8TdMv6ObqJ2/bkScc1waq6sykz6h7WuWf3ClItL98zZRnhs+EY7Mre4Dxjdzbwe5T/ljLwSIS3zF0GOxBIlPuSIArIJAcQBIxEG9tel4CHr6qfq6S1Dv0n2HIPGnESQO9KgoitrZzKJbkjn3N/8xVt6/aDIoM03gHHjJHt/Yav8PXxqBMkoCeB6raBkzdbZoRvpr+pQpmr6uVNMcQBSSVVz73I0vrjoXM4hr0flj7IDcTbKjqjWJ+Ltnxuoqlz68Qb0Dd8JXXt5EWg/J+Pzd3z+/+WOcW93LvMEfJ/6vEiB+EmEsuG17gsQBrINAcQBIx0nm5y8B4vt0g+UQJD4XQeLAMC6Nlrui6X6xSRUAqyuKojE8Ht6TTTSMjZH4updxuDRafDLC6lYz5zAvVmDvogHgf9OnWAetMjaFAAkAAwvXnvZn8BLEM6G1ovWRZsF/VUNA7pgWUynWRvSb8OUEAFA/H/OHBItPI64LLySjtj+OUt94JfNKf1y4uwDxPRdn84rMryRIvOYKALAOAsUBIAEH9Vbl8g5akyDxKT1h6X5DkPjTCBIHhvPZaLlf0XQAGA9/Q1Zx6n5ZTVEUvIjXTVtGvRFNsrQqwu+8WSJI7Jo+ZcPhbLtSVJwZLQLEE7IY1syPsWY/0rAOIPu8vvlG6eJt5GNtikVtUAVQci+VL73sRiyCjNkf/CEB4xchoDqJ60Mypvvj3B//+H+UeIqYm8tk3v3at/c1vR7AuggUB4A0fMj43AkSXwFB4nMRJA4MqCgKueYsXm8VrQeg4/FQXkg2xk9j3LYtL8si1b3RcvMiXr+aOZhdh7PtWF8bWLjfKMiGRZ9a3A73DwAPaM8qXoX7YI73/9JQcWOP52Wu/USxmMH7Fr92VWbSL7QFRzJuQI2wge+1i/+eTZ5NSuzBPyFofM9apvFHweGSQXzi4m8MOZXs8XxRC0BXCBQHAOMyziYuE+LXBImv1GcIEn8aQeJAHBZf8vMw+FcVVQB0wnpWcXlwzqe7B9a2baxA0C6c0YK6hazQjaYyKctqzBztaX8t+e839Cn60xJuyKQGqJgjyHU4VV7MXLNFW1obaPhCBNnndYn1TOFGSZb7lK/3de456t7ZpZI1GUnNy/50ejb7y1h+4u4yjctxEoKwN5Rdx7Kx8Mgf3/zROj3B4bf3JX+89W27Tw8H0KX/owoAwLwcs4nL5FgCenkxtCSCxOciSByIZ2ZxXGrbtiqKoqb5AHRomsDcfsfpDxhJjdXAhtrfRxuazwQJmNhTVJ7K6ct0rtUo1vW9wnq8pE/pFV7oa9ksSzZxQI+P7i4QSGuwnAQk7ZOBUf088yR2P3H6M+TnMt8YR5wTMr/AsjZZQ0CTMN95I4HPTtfzZRnX98IhY30TngH8Fa6hJiQp6PseU4WyvArXb6W4OaV+3g5RLwDyQ6A4ABiWcTbxfYLEV+ovBInPX3ARJA7EUxstNw+D7fqDKoBGEjTbtq28nLSclXvsz6EkAHjYOjda7s80nRmyqU9ToPgrmmRhVYxfejy6WnaO/FfksWxEV9HZl54ZkwAoIMErh7Nt+UKM1s2u9188mtJaqvuQrB3LiMUoJXhshfkLurcT8Xd/WeG/4R1l3ng3AK33VsmQLX3z3On86kAZjvH9HNKX1z24nmYPxtiH7+2fDCh/4gth9//8R/g9m07vpsanfJQ2pCcD6AuB4gBgW47ZxHc/VV+nNP1yCBKfiyBxILIQGNk4e5/KJNjYrpIqgGISPDs2fg5S/lOasn/+/rlpdEyTuTcZ2+yolZWnokleFl6WxngZer1iH/tAn1JNUzA99w9AF5n3v3d6A3CkbNPM2iTmfW2VeaOGr9e8cwR8xp673m/sMNN3JXtvCG6MiefT8bCBGWrJ5ic/Pr0O6+w9I8WuXprHKBhz+9T4Y5eNawD69v+oAgCwKdNs4gSJr9ZXCBJ/GkHigK7r0ZpNms2skiqAVkVRyEvyxvhpvKclqesXXPq+zhzciPD5Yk1ztY3D2TbzsJdVkX5vbXEtQJ96kZZNbNdhTAKga55wpriIm36M5xmAbhq+FDGmGVS0QawNJ5eG5xc5jW+1svJUXLbQPkfzx77/6xtn/1lz6mTj5WuCxAEMgUBxALDrXW6TZILEl0eQ+FwEiQO6/GWwzBXNZlZJFUC5z9avsZDpGv2zGtBwRtOZUzMPMydWBuil5/UhMOeGPqVTCLDUMn/+QosAKp0qGMefM6GJ9PLzgEsF/Uc2IhIsHlfM953ML7CKko1IMHKfrf0frx1ff9RIYhUkQHyfDdEAhkKgOAAYdFBvyeJzktEpTz9VX/dp+aX7CUHi8xdeBIkDutQWC922bUnT2eTbrqIWoHnum8A5kFW8/3EsZsa1dTRFUVzTgubMlJWHz3y/LNZcZ9V5fexxYUSXUdeXnnJJcwD6GMgqnlvCnT8MlrlWUIYdruY4QrBtzPkG8wsbND5HYIMJzMzVQnbx187ou7jEyNxZgsMlSJxnpAAGRaA4ANg0yWnx/6n6ukuTL4cg8fn9yREkDmi9Ni0qaTqzKqoAWhVF0Tj7Lyp5WdY/q4EMZBO3qeY+bkfEjJjN8eiqWfG/ndGn1NISRH/DS3RAtanisknW15y+eFQaLLOGjM4T3082uJSjiPn84NJ4Ftcyo37yP4VlesflC0tkPeWPN/6vEnfRUCNRSGb3P307kOEdQBQEigOATblk6JMHNG9o7uUc1Ft7jiDxpxAkDihVFIWGz82vYpPWu1UbLDNZI6HdZ+Pl32jblvlov6wG409pOntC8ISmAE0+861znnMd6b/t5L6VWRDhMiol5SDbJ6B7rtAon+cRzKdbzRorazHfd34xXnc5rYk0bhjcZF0Ko/O2qT/+9H/96Gy+l7NI1rMSIL5vfIMSAOMIFAcAYw7qrYmz+YnxVRDUu1r/OKEmfkOQOGDjOrWGTEN2VW3b0n5QqygKeXjcGD8NPt3dEz9+jY3egy7D5jDYVCsrD0G9z8xzIv3edbKCX9On9AmBL6WS4sxoEUA9zV+OIQB4GCvdz8NGAw1zAdaww881NiPPNdiIZkejtFwTmgZW+fvvkf+DgPF+1f544+v67RpfYAOAzhAoDgD25JL9Yv9T9ZVPyi4hBImfUxO/IUgcsMHiNUpWatsmVAGUs55VfMyGjN7s0KcRgbYgTeZhTzicbcu4GyvguV71PwwvTG/oU/ru5YrKQiAXoJwfy+UZrNbn+Tl9jSTmxqf/rfHfasjsPA5zKQwn5vvOyw6yutY04aD3GI3e0zowfm3dEDDe2/pVAsTl4F4BQA0CxQHAkIN6q3R6Pvna6+T5U/X1lBZfqm9MHEHiTyFIHLDjL6rALKvZ/XiQD+2mCZzDhGbshcWMiDchUz7sqpWVp6JJdNVLB8Eb1/QpdbQEz1/zeW7ADLKKx2c10FnLWoE1bD71/SWFCsxoE4yG9cKTY65vA8YNmPcoYHzf2f/SZSxTqcOQQbymOgBoQ6A4ANiSQ0CTvPjZpakXR5D4XASJA/bGf2sqms20sm1b2hBqFUXROPvZM9/Rkt3y45YEuFgM/pjSeraFIE1NL+Y3yfj4pFhfHKg7+BmxNx+WmQXaWFrvfKEpADNk/aL1+c4OzaN6rinzzIY1bD78vCv22jaVjcw5zV+1ZhX/wBWNhO7HEjB+6g8JGH/r+HLCImT+ItnY/+vrbTd8MQ0AVCJQHABsySHrxVsCexdHkPhcBIkDNq9b2FQbLjsP8qHdZ+Pl32zbdpNm7JTVAJczmo57fh9jDE3ymyrS7+0iyPs64/pT53C2LdeXls0YfJECMCJsLNN6zVapbzJL4Pw0zDU32Tg2mJhB+Zd8rcQkrV+1lA2nRzQPEpzXyVj5xt1lGZcvwTfUym/rVMkcLhnEj7ivALCAQHEAMOKg3pIg8TLx0zz9VH2tae2F+8TEEST+FILEAQyGAMhblsfbKmTnBVQqikIeODfGT4OMbN2yOGZdhwz5sE/bi/mKJvkpBDWVkX59reRnrGtET1J3fd2ELLMA7NC82TX1uYP1Z1RaviDBc6L+560bkeuZr5XYVCsu23u+eIVUSYZsf+w/yDI+dbbfCa1D1qa77i57uASJs6kZgCkEigOAHal/GrFxd5/lwQIIEn92gUaQOGCT1es2+wfARVFYD9w4aduWB/nQzHpW8QlN2I2wscXieEU28XTUyspDUO+vqli/+Hh0VXfwM2Q90ESuQzaB/qTlOWRNUwC2hHtCo7R4zB361azZd7QEW7HZuX+xg/FTCuwrM7q/NIrvL/Kshne2yOE6lCzju/74r8snaFzuGfv+kMzhr/0xJXs4AKsIFAcAO1LPYrBLcO9iCBKfiyBxwDDDwcYEGN+pDZe99McHmhCKnRov/waZ+ztjcfOwzM3JrpOI8CJM05ytolVUjBFdzgNj969NMgGqu77I+AnYpHX+x9yhX00ifUfmA2we69f7mONTYgF+ZWZ9p1ZctrEfO3j+hWw8Chp/7e4SAqbwNSiZz0zdXSD8febw07BZBQBMI1AcAAw4qLesZo5b1OWn6mtNSy/UFyaOIPGnECQOIBZeHP0chy3bI5AVWhVFIfObqfHT2KElO2FxnLoMfRjpULV2P5xtVzTJv2LVxazDn/VXxvXIdWVgzAGwMK1fRUp9Q1AKz6i0bBAiq3h/84wycl/tso/NaNFsx4h5zkMfB7JyPLq69seRZNz2/3ifbfyjkfWcvNuSRC277i5r+J8hAP6SzOEAUvN/VAEAmJByYIVMsPdp4pcRJP7sAo4gcQCIS16M7Bk/h/O2bRvD2e2RNgm0mBgu/8RfX/sEDK8ubGbZMNp3kZYvyu75EmRS594oIetlrDGiy7mTtGXsL72MHF9CqJSU45qsbYBNEizk701y/ZZKx7hUx/kUguC1zOtk/cV7q368j/z7+eKV7fvLpb+/aB+HL3wZ3xBgioyv0/uvC/473oZnFpthbjgKfw49T7z/Sp4cf4f1Zk2LAcgJgeIAYEPKGS7PPlVfG5r4eQSJz0WQOIDY/kMV3KoTOIfbB/lt274mmBXa+D5Zy0YGZ/uTwrKmmdKaK7O4eVg239Q0XVrkJZqyF/PygvGUloka2Fsn1r8qutPtdcUaA8C6JDhI44ZyNgTpnms2fi4gz/xjZ0cvJahNNj3QKr08G4g2LiUYvPtHpvcXze/NZfw6cXfZiQHc3d/vA7R/8WDTe+l+PvceLblGl5978+if/+d+BoY7AsIB4A6B4gCg3EG9Vbk0MkE8pXG80F2kD0wcQeLzFn4EiQOIbZMquA1ivWnb9jqB+ij98c2fyxuCxaHQmbt70WSVZA2b0owrs7h5mGzi6aqdnmDaiua4FSuw97qHYJvYc8rNw9n2Rq4ZAOXcFV1XX7i0AdO0fnmMuYONdYSG50uyhiXQs9t5hlx/JXOLTpUZdiUZI7Q/I5nIBli/pmAMAZ7BhiwAGNb/owoAQL2dhM/tI0G+zyNIfC6CxAFAnzqR85CXkRIsvkGTQpmp9WvLX1clzbg8X2/yAnSDPgtFZorKshEyUOUuVqBEH/M/DS+Kc+5TlZJy3JD1DbDNX8Nas3anPMbH/iJEV/dwLeP/mCu5c+8i/36+JpDO/cXCu0EJFj+ixQAAgBYEigOAfqk+jGo+VV+nNO98BInPRZA4AOiUUubY+2DxkmaFFiHLvfX583taciXvDJb50vfZhqZLVq3wvp2tkJkxlpmRn7msKuMuNVJSjtoBSIHKoMzI985kdfU1jpBdVMNaQjYkEize3XUnm59j1udlrl+MSdTUSDk/+L6/R3MBAAANCBQHAMUO6q3SpfvZsI+08LNtP3EEiT+FIHEA2pRUwZ2iKLS8yOuKBJ19b9uWLKXQxPqGDF6yLyl83cBivX2h9dKlMMvvKPMmqSL+7j76wjV9Ktv+xH0ESM9MablY5+unZZPBDk3R6fOAmF/K6mNuoWHeWmban84MlfXkcLbN+14AABAdgeIAoFuV6HmRTfwZBInPRZA4AI1KquAXqX3CVV5gSbA4mV+gQlEUtbO9IaP011NFSy7FYpD4je+rrPfSVysqS+7jSqwApus+sjKGLKL0qQhCpk8twZO1A8B8oT+vEq3vMqFz0bJhaBzuj7A7Z73XxzPLG677OPyaoTE2X5wQLA4AAGIjUBwAdEs1gxHZxOcgSHwugsQBwIazRM/rpG3bi5DZF+A6W887mnApFjPYTWm2LGjKEFoezrbLHBshcmBvbfRnL1q3VYZdSsvmpOsQ/APAuLD5R+Pz3FQzipcJ9Z1aSd+x+oUnbXPWMnI9XvaxwRHRWXvXLMHi39l8AgAAYiFQHAB0S/EB1A3ZxJ9GkPhcBIkDgBFFUTROx2dX+5qXfScbMhSwPpces+liMaGeLK4JP9N6WaiVlWcz03aIOS+ZGf3ZFuo2Fi0JK2oHgDkD8wZr+nh2r+WrdTs07/rPASL//i80QXrChhJr80a5/0iwOPchAAAwOALFAUCpg3pLFokpBlCc0bpPtvfEEST+FILEAYB7vSalP761bXtCoCtiKYpC5kVTw6dARrbFWayna99Hr2m69IWX8pqMMm2KmOfdZx+4pk9FUSkpB8FcQFr+0lioTL8c0es6IOH7wZgMwGt7H/F33/i1yzTlys3160qBxS9YS3tJsPgeQwMAABgSgeIAoFequ4mnNO2vCBKfiyBxIJK2bTcla/KD4+jRceGPb08c/7RroObTUBSF3OtTH7vlQf4P320ntDgisZ6x+R1NuBCLmevYGJyXWlFZqkzbINZ5Xx+Prm4S71tZZfkLAUalgqLcKNyIAiCd+cJDZUqVnGLgu78fXCoqDpudV++bm5Gvt8sMqrnMtX8ZzSp+78RfHxdsRAEAAEMhUBwA9Eoxc9Hlp+prQ9P+RJD4XASJAx1r27YMQd/jOQHf/zwI2P7uj28Pjg+PDnk5Uj1x8FAT93IIFJT+fh6uHz4XikEVRVH7PyzPq+V+VNKSz963rWZev6T1sjJTVJbs7sUhsDfWedd9/vAQhB77PreR2SfhKyXlqB2A1Gj92gzrEdYXy3hPU6ws9kbxPjPT8zUtHT4aLrs89/nh1x1sRgEAAL0jUBwA9ErxZdRnmvUngsTnIkgcWMGDQPC9R0Hg/4Tg7x/uLuj7wj0d8E2QN7p06tLPKn5Prp/v/jI7J/AVA7O+IYOXYOnVz7QoCubweak1FSbFTJoLzEFi+ZJJ/8qpT2lJWDFzAJKiZPPPU17ROiZ8UVKOzbBJD8ubRPzdN31mpu/5CztYvB1k3WB507q8l7kguzgAAOgbgeIAoNBBvSULwdQCxW8+VV/JLvezjSeOIPGnECQOvCAEg09CMLgEgn9/FAh+4n4NAufhIgYXAgXPMjttubf/CNcm1x2GMDVefjKyPW/HYJm/0Gx5CS/kNakya4JR4m3/V851HIGWDUo8OwTSpDHrbplYHaf6HELTfYHNzksKWZI36D+MZwPYd/aTltxnF9+jOQEAQB8IFAcAnVLMJj6lWe8QJD4XQeLAA23bbvpj/CAg/EcICP8WxhAJBq8SvWdYa6uKWnhSTlnFH5Jrk4Bx9C5syLA8x5YvYXAPe/q+ImOHtSCExvdJgvvyVCsqyyizuq8Sb/M64zoe1OFsW+7HGuatzfHoqmFYBZL0l8IypbYWiX0+vWwGCBmbtawz3nEpLy32BuhcNjOXuXe0MIdMIWmJzMlP/Pz8e4ZfzAIAAD0jUBwAdEpx8feZZiVI/BkEiSNrbduWIUv4SQgKl4Dw7/64cD8DwktqCpaEINb9TE9/w/0aMM71C+bYTyOr+NPG9EUYMlNUliqXSg+BvWXKbX48upLnBLGfEWyEuk6dlmuHDUdAumql91PW6t35Xwbzzc1M5gVdXV/ybGwSsQg3fj7J3CIjvr2PnM4vWKw03vjjm7+OLrhXAQCArhAoDgA6/ZHY+TSfqq/XuTcqQeJzESSO7EgG6geZwv/x/9OPMD7IZwUragipKIpi6tJ5QL+KhwHj5wSMo4drrJa5tuFT4NPdT9sxWOYpzZYtVcEXGQXvxFwz1AM/L4gthz6lJRv/zAFIldY1C2t05pvLIqu4nfU+QeJ52k3wOvrh17knYfMFAADAyggUBwCdUnsJlf0DGYLE5yJIHFl4FBgu2cK/uZ+ZwnnAh9TtUwW3ZC4gAeMXMiZQHeiQ5U/rbsgXNWjCX+YMMi+wFkBfF0XR0Hp5UpL1+aFc7rGxAnslM2M94O+bZVzX2V03ZP0Ekp4vaJ0rlglV86vE+4+WJARsdl5c7C+IDfWspFZQ1/+hu/2yPv2Y4KlJgiEJGD8iYBwAAKyKQHEA0Cm1QPGsMwIRJD4XQeJIVtu2m/7YmxMYDmQlZDw+pSb+JS8VZWz4ToAsOjI1Xv4dmvC3McKazzRb9mpFZRllUudVJm1dZ1zXgzicbcv5aQg2IUgcSJ/Gr42VCdVv6oGDWtYcZUZfsFlnfiHXVsx6akLAcC7okw/4tj9Stkbtcpy//XIlAeMAAGAVBIoDgDIH9VZyC/pP1dfLjNtz4ggSfwpB4kiKZP/0x9gf5/74x/9P3/1x4ggMB+5JJpeGaviFzPluxwx/nPijpEqwiqIoZD41NXwK45BFG3esBc7f+D44pdmyp2lzePLz7xCctJFDWw+cvXyeMgQ7pUrLNZN1kgkgExqfA5OFtztNzz9f0zumdzT3iyaRfz8b0PBW6X2nCwSMAwCAlRAoDgD6lImdT51rQxIkPhdB4kiCBHVKNmB/XPh/lOBw+VOuex7MAY+EQNZdauJJMmbcfj5UxhPZdEKVYAXWMzpPaMK7jWfOXkZxXsBD27p/I/GgXhd5nIjR1hqyQVYJ9yctWfi5nwDp07ghJKWkPbGfRzZ9/vDj0VXj9GSlZ/36stjB9Hz1KnN+zJBn0W8TP82HAeMnGayDAQDAmggUBwB9UssonmVGIILE5yJIHKaFzOF7/pCM4T/CdU5QJ7CAoihq/8cpNfEsGU8kWFyCxo/IMo4lr6/G8CmQke3nGGDNGc2G8Fl3TWu8KvEqjxXY24S2HlqdcZ3ncr00IQAQQNp4HtyvzQzOsVZSDtmYyPPgOXzdyNyijDyvuM6s2klc8/Q6VcaM3Uza/zYJib/+zsMXqAAAAH5DoDgA6PNHYudT59aABInPRZA4TArB4Q8zh5+4PF6+AJ0rimLf6ckApVnpQkYYsoxjCZYDdjd9P+fe6tx7Y+Vt/LjOmA6Na/9R4nVdZdbGGhIQJHmPCoFcGpBNHMiDxnkjaxBbNGWJ3qE55oq9EXzoZyMaxjbGsjmOR1dT/8c0o1Oe+OO7n+d/Y0MLAAB4jEBxANCnTOlkPlVf65wajyDxuQgShzlt21b+kOuZzOFAt+Szn9wPFvcwy/gJWcbxjKnx8medVTxc29Ze7pJNHA9p+ppYlWolR37ZH6uNVQTf+LpPMVOjliC3LL9GCEAFsvAaErJEN0qKw3NivXUz9Aa0/9Hk6seOXZffxkRZE1/4NYxkGd9LdC0DAACWRKA4AOhTJnQudU4NR5D4XASJw4yQPXxPAjL9P35zdxkYeIgGdKgoisbdBYtj+Tni7WdE/Rj1PXzpgPEJD68tmWtNDZ/CJPMmtBhoMOXKg9L1f5nwi/CY2dKjBFccj65k7tgoqPsqwf6k4px8G5NRHMiAv9ZraqEfft5TKijGUM/+tdwzNny9T+h9v/VFqZOY8/DrMHcEHpNg8Ry/iCb3B/lCrgSMn/uD7PMAAGSMQHEA0LloS0U2i26CxJ/tAwSJQ722bTdD9vB/3N2Ds5JaAfpTFEXt7h7QYzWbYd4hQePnMoZRJQg+Gy67bNbKOSubtYzql2FzAnArZHjU1CeqRKs61nlJ0E3M9q0V1P0opY4UNlNomEMSJA4g9niYwnq6VDIXzG3Nu8MVpK5OPuda8WSMfnGMkrXMG5dnsLiQ/jHxx3ffV76x0QUAgDwRKA4AihzUW2Vip/RXJu0mC2qCxH9HkDjUCxl5JXP4d0cmU2BQRVFMHdlo1/XvQ/77LONUSfbXVe30fIp7Fe9ybDd/7co60FqAymeuODyhVlSWUWqVGzmwN3bbzhQ0QZVYl9JyPjMHICcanxMTXGlICEjXsuYdE5z7y1xV1rWxN3/nvAGNJBIvjx+5B4s/XAdIdvF//HGi5KsUAABgAASKA4AuqS3GmtQbjCDxuQgSh2ohQPxHuH4ragSIoygKySo+pSY6cZtl3I9t//jjJASeIk9nhss+9n03xxft1jKpN378JgMsnqIp4DPFOX7Mc/oS+dw1BHOkFnyjZTMF9xMgL9dUARK7d4xpDjV1cXk8umpirI9pejsIFv+FPH/b88ePw9m2ZBqfsPkFAIC0ESgOAOjNp+prnfL5ESQ+F0HiUEkCz/xxJEGU4dotqRUgvhAszsP57vz7kN+PdxI4XlEl2ZkaL3+OL9qtZVInqA/zaHoGkGJGvZ1Yv/h4dBW1bUP20OjPGA5n2ynNqzTcb5tIAV0AkJrc1v1fFJXlHd1PTV3E6hfMZYwhWHzu+lnemUnQuGQbJ0M9AAAJIlAcAHSpEjqXJuWGIkh8LoLEoc59gLj/q2QQ/+D4pCygEQ/n+yHzlW9+DJRjQnXkoSgKmYdNDZ/C+8zmKaWzF9B6xpWGp2gJ5r2XWFCviHU+WjaH1Bm3QdfXhtx7StoUAG4RDLe+Qed/YQObljlnFe6rWQtBpbGvpdw3NPPOY7lx5D5YnPno7/1o4o/vZBkHACA9BIoDAPrSpHpiBInPRZA41AmBkd8dAeKAaiGwlWDx/lQyd/Fj4g8CxrPx2XDZN0PwdC6sZVC/9mN2wyWGZ9TK7n9JiBzYO1NSDRrKMUpobqjBFwcgNzOFZeJ5YQdrhAi/U1NQ8JguED2b+GUI/M0Zm16WJH3GH/I8ekptzO1TD7OMl1QJAAC2ESgOAOhLk+JJESQ+F0HiUKVt20oCIsP1WlIjgH4Eiw9CxsP7gPE9+eICVZLs9VQbn4/nlFXc2qfKySaOl2gKABslVK9VxN9dK6mDOvN2SPHaqB0AoAv/yfCcNW02ekcXvM1AHNNnmgCrOh5d7fo/PlITc91nGZeA8W/+YHMMAABGESgOALq8Suhc/k6tcQgSn4sgcaghGUj98c3/VY6SGgFseRAsPqU2eiXj44k/JGD8iIDxZFkO6M3ipVPInG4p65eM0ZdcWnhBragsKWXV24n0e5vj0ZWKTXxaynE4264S6E8azqEm8ycAMOdZY15wGdYnKuo/50y7IWg05nOlm9AfYq6TYX9MOfJ/7NKeC60jLvx1L0HjE3/wTBkAAEMIFAcAXVJaUCW1mCZIfC6CxKGCBDlKsKP/q2QRr6gRwC4JFveHPJifUhuDzD0/+OO7H0MnVEdypobn5LLxK4dgcWvneBk29ABzhWDeRst97nC2nUrgVKw1Tq2sHuqM26ITIZCtVFCULw4AgDXXJ4rK8j7jdtjJuR9o2czo8vyyQNdtOXV3CUwaauNFsp6Qd+YSMH5EwDgAADYQKA4A6Mt1KidCkPizbUyQOKJr27byf3x3d8GOABIRgsX57OcwSpnr+PH0BwHjSV1D1rM/72TQTNY+Uc7nvLGoWlFZKuuVGYLdY7141xbMO1NQButfA9SySal2AIBUNMxT8vgq1hPzVJmjTlinqrBJFawvBP6/dnxNbVH3SUj+8ePBec5fVwAAwAICxQEAeAZB4nMRJI7oQhbxC//Xb05HRjQAHSuK4sjx2c8hyVgqAePfwyYc2HdmuOxjudcnPI+R683Si9zGj8k1lxQWNFNUllEC9Rnznqztuq8zb49UrolGUfZNAEhB7HXF3zF+qb+XSCCnludFZUJfsllq3a5gTsE6FV2PLTf+eOv/uk9tLGXi7jKMEzAOAIBSBIoDAPrSWD8BgsTnIkgc0bVtKw+hf7hMs7UAOSmKYur47OfQ5OXmN9mME4JZYff6uXZ2v/Szkfh93tq5nXFFYQm1snuadbECe2sJktBUEUoCgTaMB4JVjBEAuP6Ts5HxuWvK+vsuw/p/R/sjVX7tcerusouzwXE5E0fAOAAAKhEoDgC6VKmcyKfqa2O5/ASJz0WQOKIKWcTl2pRM4hvUCJCHEOwqD+ZramNQt5ty/Lh7lHJm5wxYDvBN+UW7tXPjBTwWdjy6kucBWp4JlAm8nI61seSL0vrQMB+sLHakEOCuYU73xQGAHq+oAtM03VOySmgS5tix50SflVSHhvdlPLfrZ217+07UH6fUxtImjoBxAABUIVAcAIBHCBKfiyBxRNW27W2GW3f3gAlAZoqiuPGHPJj/SG0M7oM/vvtxuKIqTNL0Oe5lVSlmtQ/nZCkb7aUffxsuJSyp1jSWWK3Ew9l2RRv+ZqagDCOjXUrLtVA7ANDDdHClnytkHRx6PLrStN6VDYo5BYtPIv/+6xDEq4GGcmw69DXO3Phj3/HFy3XGCgkYP8n9ngUAQGwEigMA8ABB4nMRJI6o2raVa/O744EnkL2iKI7c3YN57knDKv3xzY/HF2QXN3fNyLViORv0JMFmeW+svJ+5krCCmaKyjAzXYxXp9zaKAm8eqzNul3XtaGg/CbZhiASAzmh4VtpE/v2a1rs7GfW92F/JYp2KQfk5rKxD5IuXZBdfzZ67Cxg/ImAcAIA4CBQHACAgSHwugsQRjQQj+uOcaxPAQ0VR1P6PP53t4FerJDvWDz82j6kKU84Ml/1doteRFfI1B8ZarKJWVBbLm013aL/faAhg3zD6+fRKQRm+MDwCQHIa7i0m13or8/MgmV/HnguxTsXgHmUXv6ZGll9HufDlSj+OTKgOAACGRaA4AACOIPFnECSOaELG2m8uzUyiANYkWZL98db/VQ7uU8OS8fmC7OKmrpdrZ/cFVun7WTJfFAnnUhoq8pQrCKs4Hl01Ts9nuTctZiwLZY41/s0U960bJfe0ylh/0lLemhESANDx3EAChrU8F5LNZDkEi8f+StZlWG/g9/UDhhl35Cs5kl183/FcehWlP859n/0WNp4AAIABECgOAMgeQeJzESSOaEIQ1Q9nO/ufdY27e4l/f3x8dOy6u8wZTx1/FityBA5gSSHTLdnF47jPLl5RFSZYzir+PqF2sJYhnc95Yx2a5nUW71Uxy3xJ33rRiP60/BrzeHRF5kUA2syMl7+kCdXNXXYyqO/YwfDavlDSKCkH71IG5ue2p+7uufSU2lh5jSLZxU/Y6AAAQP8IFAcAZI0g8bkIEkc0bdvKg2bJJM6DoX7IdV27uxco90Hf9wHerx/EbEuw95sHx9GjY+qPes7RUM0YEtnFo7r9+oMfu0+oCvUuDV8fKWVks3Qu1yEbPbAqTYFXI4P1F6vM1yFrN33reRX9aWk1wyIAdK6kCm5pChyepBzwGDKmxzw/madq29T4N5dgvmTt5A9JqvOa+e7K9vzxI5MvMgAAEA2B4gCAbBEkPhdB4oimbVu5Li8cQeLrug8Gl4wW94Hg90Hg/w2B328fBH3fB3gTDAbTHmQXP6U2Brfnx/Dv/iipCrXXh8aXqYvaCHME6/Mcye5l6Ro548rBmmpFZbGYXa+i3VSXsTycbZsY00OwWqWgKNaz9gLoYF5PFaTneHRVKyiDto3RKQc7xs6YfmlgUyPyHAtlw+19Qp6GGllpjnDh1y4XVtZZAABYQ6A4ACBLBInPRZA4ogkBYFyXq123U/czIPy/D4LB9x8EghMEjiyE7OL7jiwuMUgQngSLV1SFWpYDf1P4fPc7Y+W95JLBOo5HV43T84Lc1L0pvBiPFdz+xUDfugnrIPqVrXJyXwGwSRUgk/vMTooVHDafxQ6C/0JXn4vNODrWKrU/JJHJriNgfBUyxnz3482EqgAAoFsEigMAskOQ+FwEiSOatm33uC4Xcp8NVoJg34QM4ZIpfPdBQDjXMOBuA8avZcOE46H80OSl1LcwrkPhdeF0BNatYpxAxnpLWeWmzCnQkVpLQQ5n25WheotV1hsNWUEN9a1XRupqpKAM12T/BIBkx3gtNAUQj0NQdWpkTRvzvJqQPR5PYzOOIr6vTgkYX5mMM+chuzgbIAAA6AiB4gCArBAkPhdB4ogmBBOeUBNPkmty6u4eJv4ZMoW/9cepBIVTPcDL/LUiwY7yUP6j0/UZ4tSd+PGdOZdOlrOKm/18t78e5IVtaajIn7lU0JGZorJUhuotVtBXTd9Ksk9pKCfZPwEAvQoBxJqe+4wTrObYmdK1Bok3XIF4ZmwiYHy9cfSHsU3fAACoRaA4AOhC8FKPCBKfiyBxRNO2rVyXBIn/fk1KxvDXITB8NwS6NlQNsDrJuu//IGB8WBM/zkt2cTK/6HJp+Bp4Z7jeLZW9YUMaOqSpL1nKuFlF+r0zQ3Wk4QsZm9oz3IXyacguSfZPAEiTtrWlpvvNTkoNHeYUsYPftW5obhgK8BICxld2+/VKPwYdURUAAKyHQHEA0OWaKugHQeLP9jmCxBFFCBLnurwjLzHkAaEEhr8OGcO5JwAd89fVTQgYf+3usvWjf5U/CBZXdh04u8FamyEzt0WWssmRTRydOR5dNU7PS3AT48fhbDvmFwgu6VsrzXW0z8Viu/HtxfoWAPpRRv792sZ3TV+wGGvfUGZsTXvNfOJF/6EKTKxj7gPG3zpbX3SK7YMfU78lNq4CADAoAsUBAMkjSHwugsQRDUHit2r3Mzj8bcgazvUIDEAy9Eu2fneXYXxKjfROAt4IFtflzHDZzWUVD8HtpaEiMy6ia1qCjzdCELZ2VaTf24Tga2trqti0Z6ofMQYAwLOsB56WNOFPfi6j7Qta44SqN/ZanA3NL9ukCmyNV/544/8qx5QaWXit/MPIuh4AAHUIFAcAJI0g8bkIEkc0IVjqJNPTb/zx0R9/FkXxhuBwIK4HAeP/Ddcm12N/CBbX1fevnd2AiInBMlsKbq9lbOQqQcdmispSGaivWIG9NX1r5TmOZhXtBECRVwrLxHOA9GjaoLSTQoUezrZLBXMKNp4hScejq9of9wlNeD79Mnm2/N2PSxOqAgCA5RAoDgDoxUG9VSoogywSCRL/HUHiiKZtWxkbvrm7hzk5qf0hWcMlQPyIACxAF9mwIdem+/lAnmu0HwSL62I1q/iG70PWsrJZKi9Z2tDXXFiLkYH6qiL93i/0LVPt9aLwWXYNgewEdgH4dy5PFSCzOc043I+ti72mvVT+5ZtrLjusS/q4P478IQlNdp3NjbxDOvfj6wnVAADA4ggUBwBdmoTOpYz5ywkSn4sgcUQTAgMvXF4vhabuZ/ZwXo4Dyt0HjMumDnf3QJ4XPd0jWFwPbZ/kXoaZDN3hSyqlkeLKGDjl0kDXjkdXN4ruqaqzP4dPaMe6R9YG+1bjFDxL8+1WKa0iDeW6DmMAAKCfeUP0cV7h/EDbWnecQHeLvQZXvaFR0VyHZ23prKGn/njj7pKanDqyjM+z5++FxAIAALAgAsUBQJe/qYL1ESQ+F0HiiE12929mcq5Tdxcgvkv2cMAmCZb0x2u5d4ZrGt0hWFxHH5c5odVNTGND/eedoXplUxv6VCspR3k42y41j2+xnhcYDubV0LcqpXWjIYP+FwcAulneIK5hTfQ/1jYv2rF8gYS5c8xn+pafXQxtkypIS8gyvv8gyzjXwu8mfpz6lsjXGwAA6BWB4gCApBAkPhdB4oiqbds9/8ckg1OdOgLEgaT4a7mWa9r/VR7I77u0vgATk7y8uqAaojszXHYr84ox/QG4NVNUlkpxPcUK7P1C3zLZbhb6OsEsAFTfg/nqQbK+0O+TWdNecp0C/2YZf+vusozzjPr3cZZgcQAAXkCgOADoktLDjsEXYwSJz0WQOKJq21aCAU8SP83aH68JEAfSJdmX/XHqD3kYT5bxblT+HsHcLW6/vnZ2M+ipz9Tt+3fl/yitrBlCfwD6nC9rMVJcTxXts/z4paAM6rI3hiCJ2OW6OR5dcW8BgP4QEDeHv//IRiUt70M2/H15bLg6Y6+9+ToJ8Ov4JlnGT/0hz6jla5inLq34gnXWZASLAwDwDALFAUCXlF6eDPoyiiDxZ/sUQeKIpm3bjcSvzcYfb4uieENwFZCPR1nGdxObww1tEr46gXisZpHe9H2nVF7Gd4bq8zOXAvoUsgBquV+q/CT74Wy7ivSrJZi3Nty3pF/FfuYhAWDa+lWloAxkEwfw8D6nMXCrMV6tGu49mt87aLoP7Ri9bsvI/awJQf8W1ErajCDZvNbZ1/7Y98f9M+o68yohWBwAgGcQKA4AMI8g8bkIEocGH5zSQIwOSKYGySLOy28gUyHL+NQfkr1Fsrh8dHz2cxUn4esTiENTprVlvVdePktZ46ZcChhAraQcm0pfHO9k3i7Wz6FSVicaMufPGPYAPLz/KiwT6/f1ad44rykTtdWM4rHX3Dx3T2OsxQCOR1dTf8hXMOUZdc5ZxgkWBwBgDgLFAUCXlLJR/meIX0KQ+LN9iSBxRNW2beX/SDFLrFxXkkF8X4JEaWkAwo8HjT+O/CEP4+Wh/NTx2c9lfAtfocDwfVf6qdWXr2pftvv+LGWz0qenzGkwEE1Bo5XC+qloF9PnMKI//aZm2AMAxBIyUTdKiiNfH7EYLB67zHz5Clh+7GseZRnP8UuYEix+QW8AAOBXBIoDgCKJBfX2vmudIPG5CBKHFilen/KC4c+iKGqaF8A8Mkb4Qx7ES9B4rg/kl7XBvC6qM6PlLkNAtkaWPi3+hUsAA9E0h1aVaS9kO4tVpkv6Vlp9KnJ/unctQSoMewC03nsD65ulXtGtTM1zLK0RZT4h12wZeS7B8zRgDSHLuHwJ8z6pSU4qP47xrBkAgAcIFAcAfXjwsQCCxJ/tPwSJI7q2bY9c3AfJfZAM4m/JuAlgUTJe+EMy9coDeTmmjizjzxn7+8ce1RClr14bXodofdluJVucfA2Bz3ljEMejqxtFYw3Zn8MYkEIwbwgiij3HKg9n22Xm/emhmlEPwCN8QYo6jUFTRmprGcXf0XZL0fK8j3EBT62Xan/cJzU5dfk8n574NRrPmgEACAgUBwB9UlmcVX39YILE5yJIHCq0bVv6P94nNi5LgPgprQtgVRKI+yDL+L7T8/ljbT6E+wiGZzWr+MT3GVUvQkOWcysvZwkSx9BqJeWolNXLKPP2SOVcqsz700N8rQLAY38oLBPr8jVJ8KHy8l0raueNw9m2pWDx2GW1tlb9S0k5Nh0wf0yUjcLyXFqeT390eQSMnxgbewEA6A2B4gCgDxnFn0GQ+LP9hiBxaHHi0slcIdfUGzJtAuhKyDJ+6g95IP/WkW3xsQ3metFcOrsviLS98LH0SfEzuj4GNtNSkMPZdsU4llQwr4bgnFdK6iJ2377RHjgIIIpSYZkamiWbtS5rxeXmyZuRr9nLFL56A2glX/vyx5HLJ6HJeRjXAADIGoHiAKDP/1I5kYN6q+r4500cgUNPIUgcarRtK9f9OKFr60/JAkzLAuiDbELxxxv/19f+mFIj/6pCRmYM2x9lLml1Y9Q7ZeWx0n9r3+4NvR9D9ztFZVHxovhwtl26eIE4NX2r2zmMgv60oaBvp9SvACR2333E+ly4olst5DNrRXNrbL5MAgwgBIyf+kMCxuVLmKm+Z75NTBLWSgAAZItAcQDQp07oXMqufhBB4nMRJA5tPqR0bYWgOQDolWxI8Yc8jJeH8lNq5NZJ27Y8vB+e1ezSsrmg1FCQsMnBSt/9TJfH0ORFtNPzJbWRljEs1pontEcqfatWUIxNBcEHlYJ6ILgLwFPUzZHJWJzN/FPmnlraesPPFSwEi8cso+VN7Br8hyrAimPl1N09m/7o0gwYlw1rH2hpAEDOCBQHAH2ahM6l7OKHECQ+F0HiUCVkE69SubYIEgcwNMnsS8D4L/PIPXrF4H3w2ukJ4FzWREk5dozUFy/fEVOtpBxa1i6xAta/0Ld6sZlpf9J4jQNQ4nC2XSksFl8QzKsONa19RsqvV5nLlDHbyuhmRi3zn00HrChkGD9yPwPGU7OndE4CAMAgCBQHAGU+VV+bhE5n7QdeBInPRZA4NEphN75cU7sEiQOIiYDxf70nq3gUVrOKv1NSDiufEr9kvoOItAQoS0bHUkE5qki/t06wb80ybk8tv/+aDL0AnrrnKiyT6bmwkjmMpTrU9DUl7WvG2GtrvkwCRPYoYDy1JAMXCr4CBQBAFASKA4BOdSLnUa7zHxMkPhdB4lAnoWzib0I2VQCI7lHAeJ1hFchD+xN6wuDkBZDFeWbp5yNRM2f53z92OoNgnnJGV0csx6MrTfe0qGuYEORVRvjVN8raoSsazmkUsT/JPWiTNgCgkMYMtzPjdVrSrZaaf8rz3kZL24Ws3VrFDGRvfFvx5StAz9gp1+Rb/9c3Lp0vosua6QOtCwDIEYHiAKBTKout8qDeKlf5DwkSn4sgcWiVwoOVXYLEAWgUAsblgXxKD+UXNWnbtqQXDNrfZJ45NVr82JnPdqysN5nzQIFaSTlGkX//OPP675SS4Pcq0999jyygAJ7ySmGZeL6eH00ByO80VlAIYC9pI9PIlIxe1ln+kEQmHxM5pT0/3lW0LAAgNwSKA4BOfyV0LktnRiBIfC6CxKFSCOCrjJ/GtCiKKa0JQDM/TtX+kIfy+y6vl9rvaf3BWc02Pc7896fevkiLliyesbM5jjKv/z7UsQsQMUto7I0PqWaqB2D/fvsUNk7mV4efWbu+6B1ttLKG8Rap83P9I//Ha5fGxmO+YgkAyA6B4gCgU0oPKZfKqkeQ+LN9giBxaPUhgetrn2YEYEVRFKcunYfyi5Cs4mREGraPNUb7V+n7SpSXov73yot+K/2ULG3QQMsYs3k424557VaMA53TEARfZfZ7tV3XABTO0xWWyfo7mEpBGf5nqcKOR1fS5o2WayLixrLnxAxgvw5tZJIve+OADMh16g/56qX17OLyLGBCiwIAckKgOAAo9Kn6Wid0OtWi/yJB4nMRJA61QuDe2Php7BZFwfUFwBQJ5PWHPJTfdelnF5d7zYRWH5zVTF6xMqDtGKmfy7ARAIhKWdbhKEE6ITgoRpB6k3ggi4YAo1GE/rTh4meQ/MLoBuCJ8alSWCz5AgLPAvOkabPcWNm1KvOIMmIRPtM9AVNr+iN3l8jE8sark8gbxwEAGBSB4gCgVypZxcuDeuvFF1UEiT/bDwgSh2aWsmc+5bQoCj41C8AsP4ZNnf2H8ot4T2tH6VsW56DjzH7vsnj5Dk1qJeWoMvu9Nf2qd5sZ9aec+hYAO2PiS3gWmK8zRWXRttn4XeTfz5evOkLgK4YSvgIgiUymRk9BrpU9WhIAkAsCxQFArzqhc3n2ARNB4nMRJA4LLAfuNc7+5/EA4D67uASLnyZ8mmXbtpu09uCmRvvKoEHb4fdZeBF748cKXr5Dk5mScowy+71JZ30OGWJjBwCWh7PtMpP+dO868Uz1AFb3SmGZUggU/w/1uNI8oVFU7s0I84XnxNz8fJnIPELLuzyen2HQ9Zc/5IuX+0ZP4T2bKwAAuSBQHAD0miV0LnMfMBEkPhdB4lCvbdvS2X7o+LEoCq4xAMnwY5o8kJcH86mObWQVH96Z0XLvJP77VjWlS0OZWkk5qsx+b03fGsRm4r8vx34FwNb97jl/JVCvGp7JWn32oOkrSyq+THU425b+VEYsQiobGflaAbJ1PLqSBCZvDN4byCoOAMgGgeIAoFdKDxTKg3rrtwdeBIk/2/YEicOCseGyS/bdKU0IIDVhbLP4UD71+47V/tQ4m4FfY/rmk87o1dDkeHSlZnwJwTFD/r7KxfkSQR0ybqdOQ/KFoTN8V9Q5AG1Chs5SYdEI5sybpq8svaMct8+v+PIVkM4a3+Jz6Xe0HgAgBwSKA4BSn6qvjf+jSeiUfskASZD4XASJwxLLD08+0nwAUlUUhcwnXrv0Xn5vtG1LsPjwPtNX5gu/x8Inaq9D4D+gTa2kHFXiv+/ejH41mME2H4SNB1Edj64I8AKg6X730phFoHjGfPvLukhLH9gMGypii/ms5TKTjYxD2qAKEPke+6ez9Vy69GPxhNYDAKSOQHEA0K1O6Fyqg3qrkr8QJD4XQeIwo23b0un4xOkqyCYOIHkhIPSNSy9YfIfWHbwvyT3zhr4y18hIfZBNHFppCVx+NfDvizV2ZBHMG4KNYs+BqkR/V7b9CkAyc+U6kbrV8FzW8vMGTRuio26ID1/WKSMW4QtDZZLjAzIW1mPWnku/p+UAAKkjUBwAdEvtAcn5Qb215wgSfwpB4rDGckZXAqUAZKEoCosP5V9S0bJRTOkr5udEBPFBqzrT+0uM+9lNZhlUo/etATN9xw7EnDkAsLN+S+VeGD1jsPEs0JrWR7E3xMf8amiT2FdJmBMBv94jLD2X3gwbZwAASBaB4gCgW53Y+ZT+OKFZf0OQOCwaGS23XGdTmg9ALkKw+FtnMyP0k/PJtm15aD+8M/rK78LPLw3UxTSMBYA6x6OrWsuYcTjbHiTgasDg4cfqzLrXXwrKMNScpYp8nmxGAvDU/W7D6cxqSyAnZA7aOD3Bi+Oh5qHzfj9zCAA9jbX3weJWnkm9o9UAACkjUBwAFAuBw9fURNIIEodVVjOKXxIoBSA3ftxrnK2H8i+paNUofag2WPR3xn9+Vz7Ti6GclvGlSuz3PPaFfjW43jdYR9x4cK8JwXYAYGXdZv59S+Sg4pR8zv16CdlzS9ogOf+hCqCFsWDxCS0GAEgZgeIAoN8XqiBZBInDpLZtK8ZUALClKAqZd+wncjojWjQKiy9w+97YZmFO1Pjrv6b7QjktmT2Hynoa6z6W1VgQgpebDPpU7HsRmUABzLOjcW6cyOYWDZnaU0hwdMn1EjUZzLW/HkmUle4YATxcm8m1vmugqBuHs+0xLQYASBWB4gCgHy9c0kSQOCyrjJb7pigKxlQA2fJj4NT/MeU+hDX6j7W5a9m2bS8vSP3PLZ2Nl69kaIMFWuboQwVwx7iP5Zr1uY59HzqcbZeJ9Nt5Zg4A7KzbapqlM+bfa4S5kZZA5ViBiTE3dKS4Vm0cgHljrqz7Pxoo6g6tBQBIFYHiAKDcp+qrPKhqqImkECQO66xmciVIHADusopbn1tuhCBdDG9qsMzvevq5Y9oM6EbILqZhfVz1/QsOZ9tVpHPLdS2kIYh503q/feH6ZZ0N4Kn7nYx9GtdsbG7BY1qClTeGnieGzWwxNz+nOIdouKSAZ9cOR07/FykqWgoAkCoCxQHABl66pIMgcaTA6qcLeRkEIHtFUcgcZJ97EVZ0ZrDMfQV0W8gwdOmv+YZuCyNqDYUIgW19qlgLZdevRj321yryufG8EoC2+52J+UYHSrpYkveyodeYMTc/X2b6tRsAzr11ur9KUQ7wXAAAgCgIFAcAG/hceBoIEod5IYPrhtHi17QgANwGi18mMCbywD5O32kM9p3Sz1867S/+58lcqDJw7l/otTBESyBz39d2rK8zZbkWCgFITcJzlorrFoBS7xSWqUkoMLVUUIbrFCoy9Akt5zLO6DplrWp7TQOsO+6ecQ0BADA8AsUBwIBP1Vd5UNVQE6YRJI5UWA3Ma8ioacYGVQAMYtd4+Uc0YTQWN7F2/QJ8bOCcb/zcZ0p3hSG1knK86vnnVzHq9nh0lfOziNjBX5Xh/voSMooD+M3hbLt0Op8f1rROp/7HGrdzZbh+Ur9ObxKeQ/D+D1iAX58eOd1xDzu0EgAgRQSKA4AdvHyxiyDxnh3UWxN//OOPc3+MqZFebRq+DkEfAxCEzTNTw6fAppJ4fUf6jbV5bdfzQwsbFab0VlhyPLq6VjK2VH394MPZdhXpnHLP+hz9/Hv8dHkV8bRSyswLQPfcuytkMIaFtdM4g+v0MtVNjGFNA2AxmpOYVDQPACBFBIoDgB2fqQKTCBLv2UG9JS9cz91dwNjEHxchaPwk/H/o1iuj5f6LpgOApOaX3OPjmhorb9m2bdnhzxtzfQO9qDWMF4ez7b42I1WRzumSfhVd520fgs9jbpwjoQWAed4pLVedUB3zha0OhaDly8yun5h9iE0bAGTsrTXfm3vc7AsAQDQEigOAEZ+qrxJw3FATphAk3rODeqv0f3x74v+Sl6V7/vju/50f/jgK/y7WZ7Uea5pOv46D+AC8oCiK2hn+4gJjRlRnBss87qjfVU5/Rvtrf32TyQwWacl83dcL4RgBOTe5ZzZUkq2+jw3XFdcrAG0OZ9ul07mpt041g3HMNUdi56MleHmzx02L99fphou3+Vm+SMJms2HG44pagAEfFZeNawgAkBwCxQHAljOqwAyCxHt2UG/JA80L93KgTumPD/6QgHEJHJ+E/xarsbqLnmvRhpIqAAZnOeswY0YkRVE0zt4mrK4ys+1wXQO90TKuVMZ+roU6zb1v9bGOHnG9AlBoorRcZDDuXmrPWjUFL4+N/3wr9QwgspBVXOvGo1e0EAAgNQSKA4AtU6rABILEhyFB4su+bJV//9wf/xzUWxcSNE41Ls5y5layaprB5/yA4fGSDquyFoy82dFcZmzgXFk3wiQlmZ9F5wG4ETP6ERh3J3b26z6yg1YRz4fMvADmeae0XKmte0mC0v089EZRP9kx/vNTeo6wCt5DAMvRmiSvpGkAAKkhUBwADAmBxwTz6EaQ+AAO6i0J9q7W/DES5HPuf5YEjcufY2r2RSVVgJ79QRUAwwqZoa2+xKpowah9Z+rsZZFba74XAs21z4emvm1Yi8CyWkEZ+ti8WGVcn/SrjvvV4Wxb7kUxgwTZgADgqbGpUjpXvj4eXTWJVTeJFtK+v1XGf/5z12IOQdSsx4HlXCq9biqaBgCQGgLFAcCeM6pALYLEBxCygE86/JEb4edJhvEf/jjxBw/b01JTBWZw7QFxEOyDVU2NlXfdLMFjrmegdzMFZdg4nG13PS8dRTiPJsHAuJUoyVZfKf1ZrLEBdEVrNvHPNE0vUgz41ZKkaaOvr9H4nytr2g2uxSxUVAGMrNXUJskLG3QBAEgGgeIAYMyn6mvt/2ioCXUIEh/AQb1V+T/Oe/wVsujf88f3EDS+5w8eBPxUUQWgjwFJqqkCrMjaJtZx27brvBTfUX5+TVEUfIEK3JO60XWgeIx5LuPBr2IHtL3q8GeNIp5Hk0k2UABLOJxt3yfi0Ij7YQ9CYF+K56Slv+wY+7lciwDWoTXpQUnTAABSQqA4ANhEVnFdCBIfQMjyfTHwA4ATf0jAuASOT/yxQUsA/WjbtqIWgKhzGYv+oOniKoqicfY2GqyUFTwEmGu/V5GhDeYpyfwsOgvq7Ssj5AJm9ChV9VEp/VnLqulKAJ6wp3Wtm9rXNXr46gl+pSVYcWzs577kMqMv3TRcRsDSzwG0biThngsASAqB4gBg09TpeHEKgsQHEQK0JUg8VqC2PAyQTOb/+LJcSNA4rQJ0rqIKgDiKopB5TGOw6CWtp4K14ORVM6iNDZzblO6IRNSJzU2rjOuRfvXTRhefLg8/I+Yc6AtdCcAT3rFWGe5+QnfrlZZgxbKLecOjOcRmxP6T0/zhby4jIJn1K/dcAEBSCBQHAINCUPKUmoiOIPEBhCDxb05PMJgECZ37cknQuPw5zqg5RvRI0L+AZDVUAVZRFIWsSyzNh6tE71N1yPAOpEBDJuwuM4fFGD/q49EVzyoe8PVRJ9KvYme1q+lNAB46nG1PnN5NvJe0UC+uUz2xMH/S0m+6fu8Qa0PHDddiFDxrB88B1sfXLAEASSFQHADsOqMKoiJIfDgnTufnvSSAfeIPyTD+wx8n/uAzZMAK2raV66miJoDocxtgVVNDZd3w951VXrhr3xz4mW6IhNQaCnE42+5qfhpjnTijG6nsW130hZhBP2xAAPCU91rHfD9mNQnWt4bspqnfC7Rkv+76nl9FOo9L5g8ArDwHeKSkWQAAKSFQHACM+lR9bRxZxWMhSHwgkrHb3QVja1f6Y88f30PQ+J4/SloQWNiYKgCi+x9VgDVY28S6s8y/3LZtzE90L4IMbUjK8ehK1tyNgqKsHdR7ONuONX4wJjwtdgB9FwFfVcTyf6ELAXh0n6uczgQfItWNlCQqyWceNfbX2EZH12oZse8wfwCwyHOAmloAAKBfBIoDgG0fqYLBESQ+kIN6a+JsBIk/Vrq7LOgSMC6B4xN/bNCiwLN2qAIguoYqwKqKopD+UxsqcrXkv/9O+flc+jZgfYLUaBhTrAb13oRge+jrV5tKfobl6xKALh+UlouNlFhZyH6tpf90NZeMlaSj8fWZ27XIfAlYY8xQVh7e7QIAkkKgOAAYRlbxwREkPpAQJH6ewKlshvP4x5/TRTgvAA+0bSsP28goDsTXUAVYk6WMfWXIEr6oSvn5nNH9kKCZgjJ0EZA7ilDumu7zNAVZ6jZCRs+VhMy90eaKbEAA8MSYpHWefBmCfdGPHO4HWrJgd5VcYxTrWuRyiaaiCmBQo6w8fMUDAJAUAsUBwD6yig+DIPGBJBQk/pgEwp7785OgcfmTwFjgzoQqAAD7iqKYurvMfVYslCW8bdvS6X4x1Pi6J3APKaoVlKE8nG2vm0GsilDuL3SfZ8UeMzeN9SdN1yQAXT4oLlvKGyn/UFCG/6XeuY9HV1rWt2vf+8N8Nta7iM8OABY3owoAAOgPgeIAYBxZxQdBkPhAEg4Sf0gezMp5SobxH/448Qe70pGz91QBACTDUkBG1fG/R50DHToeXTVORzaxlddqIXN0jE9V1/Qg1fWzzvp/FLHcbEAA8PAeVymeJ18n/gWEkh44GA3ZsGXj4rrvDiquRQAAAAAEigNAGsgq3h+CxAdyUG/tufSDxB8r/SHn/T0EjVf0hF5Qr0q1bTt2vOACsN48DbpMDZV1M2QLf8mO8vPgU95IWW18LRFjHXIdguwxX+wsdesEe29mfj0C0ONEcdnYSImuaNkkte6cMtaaNtds4jyrArh+AABQiUBxAEgAWcV7XZASJD6Ag3pLAsRPMq8GyTTX0BuQGbKJA1jH/6gCXYqikLmMpcDlcUf/TiyXoc6BVGn47PQo0n+7qppuo76OVgr2DtlEN2LV2fHoimdjAO7Ho4mLu3HlOTeOjZRDyCKQz9/7LkOfim3dQO9Ya9osr0VNc6bw9QfAEtYcAAD0iEBxAEjHRxZQnSJIfAAH9daGPy78XyfUhtsNmz7Qg7ZtK2pBZZvQLgCQHktZw0Yv3KvG1DUQVa2gDOsEwsWY687oNs8LwTsxA9w2DmfbpZH+RL8C8As/fsmGlQ+Ki3iWwcaWSkEZcnpncmm5zSNuNLvkKzcAAACALgSKA0AiQoApn1XsBkHiAziot0r/xzenO0vjUE59fyPbTb82qAJ1PlAFgCqbBsvMXE2hoihkTtMYKe64bdvn5ggjzf0/1DWQrBBcEns8WSmoNwTSlRHqjHFhMbXBederiOWlXwG4txfj/raEKU2Ejn3RUAg/t1z1Hco453oDAAAA8BOB4gCQllNnJyhDK4LEB3BQb1X+j+/OZlBaH33uI9XQO/qaImQTB1SyuKHmmmZTy1Km6+fuR5o3NE7pZshEbXQtUWVaV1bM6FMLuzkeXTHnAuDCxinNm/6nZDBG18ImPA3vilbdxLwTY+7g2GTGWAQAAAB1CBQHgISE4GYCTldHkPgADuotyTwjmcTJ8Hz30HTXUJ9rDNf1K7qbKmQTB/T5gypAh6aGyvrki/O2bSWIr1Rcbr4mhVzMFJRhc6D/Zl1kblxcHfn3LxXsFYIzY92TyCYO4N658vIl/15kla+c9CS3DUQa7oXjFftLjDnp5fHoKvd3bI2SclTcugAAAHCPQHEASMyn6uvUkUVqFQSJ9+yg3trwx4X/6wm18a993+csPVj/23Bdk1FcCbKJA2qV1gpcFAVzXr1t0zg7gWXVkv+7BnWoYyAHGsb60UD/TQp1ZUIIXoo5jm72/O93aUaPAXA4295TPj++zCSbuIp1e4ZBwBo245UrbBSoMq4vAAAAAI8QKA4AadqnCpZCkHjPDuqtyv/xw62Q+SJhl2FjB4ZRtm1bUg0qnFMFgEoVVYCOfTY0R3gqAO8ddQvEF4K+GoP3yKHvqze+rq7pMUupI/7ujcPZ9jJfWRtFLCsZxYHMheBU7V+G42s76HM+KvdCDe+Olp1f7kQoYxPqCwAAAIAyBIoDQIJChuJTamIhBIn3KGQRlwzi3/yxQY38q/HHrtHrxbKKrhdX27ZHzmDWYiCDa9PiVxdqWk63oigunZ7PLS81R/DXhMxbtV4Xsm7hxTtyE33MP5xtby7x78ZYdzAuLC92puzNnv7dTp8BZJg1FsDvZMO/5ue6tR+rWB8ih7nWsoHfzEkBYD0NVQAASAmB4gCQro8sYF5EkHiPQhbx7/7YozZ+89Zov7N+rYzoevGEjO4fqAlAJYuB4sxzbbCS+frxC3fNX8G5LIqC9QtyM1NQBu1BvTO6ydLqyL+/6unf7dIXugmQt8PZ9p7Tn3jhI2v3QeX6BRMN98RqiWtX/t0YGzz4+pWuuTnvQ4D1NFQBACAlBIoDQKJCEOouNTEXQeI9CVnEL9xdFvGSGvnNfsj6b/W6sWxM94vqnCoA1NoxWOa/aTYTpkbKWYUs4hauiTO6FTJUKyjDq57+3ZTqyJTj0VXj4r74X6ifRMpQf4+soEDGwtc0tG/4v8wsm7iGzO5Zvk/x/exSwblvLPGVmxjzB/kSSa4bCQB0o6QKAADoD4HiAJCwT9XX2vFS5ynyQI8g8R4c1FtH/o8fjoDceS59vzu1WvgEsldutG1L34zA17uMDRU1Aahl8fqsaTYTc4fG0HqkMnBNNL5OefGO7CgI6BXLZPAcegy5DnUEW/OJsoe+16Ubgr2AfB3OtiUgWTb8bygv6j6thQFpWNsu+mw7xuZnsokDGGqNNBTW2QCApBAoDgDpk6ziBET/Sh5wf5PM11RFN3xdTvwhAeIfnP4XCLE0Lo0s/7Xx8u/QFf8/e3eQ3DSy/wFcmnr7l/8JxpyAcII4RbEGTjDJCYZsYQFZkC1wAswJJqypFMoJyJwAzwkm7wT9745lCCEhTmJb6tbnU6Vy4PEmUrfaaklf/bReIYQcKlDBkMfok0yP3YJL+cjlZvHjDMaEauIMWdfBnPEi/6gN1o2co2XjuMPfvWgAfGugYw7o1puquwdVFjUZ4INS/7VrDv7c9tp5QTsf7WL8mjsAd/V7z9bHGy0BKIqgOEDh2qrZT7XET9KFsq/Pm4eqC99BbL9xXD5XswozIy3yS08LqWI/zXz9n4QQPMywJm1b/6UloNf+yHCdTwp4y8VgxL46zGT+MG4/+/xQ2cQexYAdd70CL44fLRK4GQ+xbTLWdLxPLbK/bA51zAGdfTftxI+dnq9mOh/cH2D39CG8Px3q2Hi99anpwfaP2yD4r3Rxz+vQG25+0JfiBmNdQWZGPVsf32sAFEVQHGAADsZHTfx4qyV+chZgfN48TMtIcyyurSCeAuJpGWuRa+3FcVhK5dO/Cxj3HhBZHw+RQI+FEEaZfieqJp6fHKqKj+KY2Onx3HbiAQkGrunBOmwu6d8s1eutT6o33r7tplW3b+H75blSRxXq5+xXMEDtQ1HvM1jVd0KpnRl6ddU+HB+vO2ft4m0kHw2NHzh3h9Wdc6+TuQYARREUBxiOVGFDqOZyKSD15Xnz8FVcVBq+QmqbNiD+tZrdMBhrlYUcHoyPSnpQo4TvkZd2y9ULIbyphPKh73YyXW8VLvMzyWQ9+/yA0we7EUP2euvTaQ/ORe4v8G/WHcxp7B1Zt+F1+9S4q/P+dswBA9I+nPI5g1WdVoriMOzzsuvmm+ueP6Q5gwfMgLvOQ0bVrNBTn8hVAFAUQXGAgTgYH6WLNbta4krp5DOFR7+2gfGRJpmJbbEZlxSamQfEtc3iTkobd3VdNwVsxrxiKCvStu8zLQG9Hqdp7vNnpqvvBmR+84epfruTaSFzMLirrsdBHyuKq954d8c93qe6qqhnv4KBORcSz6GIyt6AH2bZtLd2K+576Xr/tOPVGP9iLKd9ZLTm9Tn0gBlQ4DHu1HcbAKURFAcYkIPxUbqItaclful8YPyvuAyyGm4KysflWVy+xD+mZafK40ZBn5w9nNE+pFGapoBtUFV8RUII4yqP1xTD0L3M9Nh+Ute1i/R5UhFb28Fddf1GifGv/sc2mLPuY2tjt8i6Da8LQ2wNsE2AbvxV5RFCbl5vfRryA6h9OIefGi6dPwS92T7cceP56op4wOxnvbluFfeVse4gE1s9Wx/VxAEojqA4wMAcjI/SaxlV81tMComnsPi/qaJ26aHxC+HwVD38TaVKyV3stQ9nlOi4gG1QVXwFYpum74y/tAT0fqyOqnyr/rsBmam6rtM5yFRL3MpEE8CZpusVaMPgV1n3+fNpW9WSO2jbsKswz0b7ivW+7FPz/aqxZ8BwxO+h9LD/OJPV9cbU7jmn68eDvFeN2XUHLacDf3jjV/NL4Gb6dg/eOAagOP/RBACDlC6odvEKulyl6gw7aXnePEx/The+UlC2yTkIHLclbde4ml08HFdC4cs0ifvGpODta6oyKnK/CSEcqky7HG1IPJfXFLPafWEnjquJlui1nKv+uwGZtw+Vt3rceJ+P36lTzQBngYvTF8ePTjo+d02/+6rrAPcdE7M+x+0qmDCqLgnddVShft4WwEC0IfGdTFZ3P84FzIvpw5z0JI6dadXt/bXHV8wF1z2fMR8FljEfGVX9yyz8rWcAKI2gOMAAHYyPTp83D59WAn239aRdqjY43lSzG8XppHEa27fp40rHdU03GdOSbl6PK8HwVTmJ+0DR1W3qum5CCCVsSvr+S2G1Pbvt3QiJc25fGMWP9/Hzz/i5G78vVN7oXx89q/KpFnfR1D6VvUklKH5THzQB/KDp+Fz2V2Hwda/Xsd1hqW3ZVVB8XF0ezu5qP/f2FhiIzELiJ6+3Pr0aeH+N7bW9kgLSXb6pbdyTfcT5KrAMfXyjd6NbACiNoDjAQKVK2M+bhykc+V5r3Nm4Ondhrg2PT88t/5z7uVplkDz+7lE1e+p6vqSb2BtVvoGw3KTK1NsD2dZ0MfxJAdvxLITwMYXf7b63IyTOBfPvhbRffIn7xyR+7qnc36vx+ibzYw8ZS5Wx09s8CplDrEN6OMJ+Dz9Kgd4uQzmb11wbWCfnMMvT5YNov1/x9/c7Wh/7FQxAZiHxZFev9eccRROc+dDxnHSUKvBeqLK/7rloeoDDw/z9Nza/IwN/9Gx9Tr3FBIASCYoDDNjB+GjyvHmYbjw90xpLN6queE1WGySfm1aXX1xNf/fPFf/tefh7Lv2sOng/bKeK/QPZ1lRlrJSQ118hhHuCrDcX222nmoVOhcSZu3hRN+0jT+K+sh/H2FvN0+l4TeP0c+ab8U5PFuFDJSh+k7YCftR0/PvHl/3li+NH6z4nP3HjenliWzaxD7v69aMr/r6L6zz2KxiADEPi+8KovTpmOk7M2uEkjqXpL47j65qXTs79ecv5au/OW8aaAa6dl2xW/bvH3egZAEr0myYAGLaD8VGqKq5KXXdG1feK5OeXnbi8vGJ5cuHfCon3w26q1D+g7S3peyOFJ/+yC99MCCE9ZPS+EhKvfA9/2yeuenAp/f2b+L9/bR8uoJu+yb3y/0mqRq0389dWyNaXi5loAvjR661P6eHOTs+7rgiFr3s+2NgbimnT8Q3/3n4F3OUYlltIPD3A8krPnRlpgt7p+vr41rmx3cVbZd1XBJbhzx6u07FuAaBEguIAJOnVjapywO1NUoX+IW1wW327pIvB4xDCe7vy9VLgtG2rN1rjG2H5mesqBI/i8r4NjI811/rGbDULief+QINq4mVReex6hx6OgCs1Hf/+y46p99e8Dm5cF9SmL44fjS78uat520e7AZQrw5B4sqvnvhlpAue1F4yv+Hkt56uqywNLmJuk69Z9fOugB2EAKJKgOACpqngKfD6Ny6nWgBs7iWNoqDctSruJvNNWyeYKsX1G1SxwuqM1uMTjBf/d2X4U96fPKoyvfMyWEhI/ret6okeLoj+vJ0wPV+s6JH1ZKHytx9rXW5/cuF6+psPfPbrw53EX8624XzV2AyhPCmHF5UuV37Wcvfi9pLhNv0w1wQ/zsZOO22R07mGzrTX/bg+X5WNLE9Bj6X5c34rwTD0IA0CpBMUBOHMwPkonPduVsDjcxHzcDNVhgd8ZbwRXLxfbJVV2SDcWN7UGl+wft6n+Ma6+Vxg37lbTJ58LGbOqiRemrZQt5PiLOWZsI+0DV2s6/v2bV8xrhrL9Reo4JH1x/7k/wHEFrED7hoIczwtTteK3erB/5yma4Cd9qSq+zrloaW8aXRUPusCv5yjp2vWffZyD6B0ASiUoDsA3B+OjdOHC6xxhMWeV+NuK/INU13WpF4Xfqyz+XQqbxuWv+GNaNrQIV7jLKyJH1ffA+Ks24Mzdxm0KAXytynmwQ0CgTCpmaxu4lddbn9J5SJfBi/H5P5yr5LguKjiuTtPR7/39wp+7mMPZr6Aw8fiUjlc5hsSnlXsUl1EVuJ8mXe8XbdhyneP8sJ2P82v/0wTwS32sJp64JgdAsQTFAfjBwfgohT5diIXr7bYPVwxdqRdNUmXx90Pv3LaKeAqbPrGrc43HS/hvjOLyMi7/pvHXhp25+bhNF9lT9f9SAveT9sEkCtNWzJ5qicv3e00A12q6/OUXwuGbQ9r2wh139HtHF/68ObQxBSz9OPWqmoXEczwvfCqESi7ivprOabu8R/CkHevr5OEyYBnn0y97uGrT+L3uvi8AxRIUB+AnB+OjSSUsDr+y2z5UMXh1XTdVua9R3AkhfB5ideO4zaO07ZUq4iy2v6R9ZNkPE+zE5Uv8b6dlR5XxG43bN4Vt2r7eLZoqPT87jPOrqWaAa3UdUNm84udVc+N6tZqu96e2AvC6nbRBNyBzqbJwXNK1nJeZbsKe41yvOVb077x23dXE01zUfZG8jDUBPdTXIk2+3wAomqA4AJdqw+ITLQE/eduOD757V/C2jePyNYQwHkJHpjBuXFLI9GvlIvJN3B/49q+y4ny62ZUuHM+rjKtuf/m4fVXNqoiXNm7fCswWz5zqZ8LzsIDXW5+ajldhs6O5YKP3V6qrcGIKdm5csm/Zr4CFtQ+afKnyfSvcJB7f3+rJq48VPViHf3TDpQ5tK5fwZgS4fL6yU/X3GvY7PQRAyQTFAbjSwfgoVRWfaAn4ZhLHxZ5m+FFd1+l7YlrwJqYbMamy+JtSqxqfC5qmgPgze/Wt9pEhe7ym37MTl7/ivvq1HY+bQ9/xUrX1ahYEeFngfphuqKkmXv4cIs0f3Gj+bhrbRHvA4poOf/fWuZ/XOSc51u2r83rrU5p/dBUWn+9HXTyE+lHvQ95eHD96FT/SG6ZGmW5C+u51zXWx4wT9mz9Mq3LfuHmRB5tv9r0G/DhfSfOUvr4Ns/GWJQBKJygOwC8Ji8M3k3Y8cLkhPGmfAtRf22BmEeK2jM5VEC8xaMrq96G0z6y7WtmoHY9fzoXGnwys3XfStlezauujUo8rdV2rvjQMbjQPaz4Fy9RlaHrzwtxkXTxMsnpNR7931MH+lJz2oEI/cEsvjh9txmX+8HCu0nnfdvuwDjiv7a+TOE6Fn4G7+Kvq7z0o1ycBKJ6gOADXEhYHIfFF2qgaxusU00Ws9204dSfXjUih2riki3LzCuIC4txW1wHtUbsPp0rj/8blfRuiHpXW0PMHO9J2VmUHxJNUVfmV4TUMbQXtqZb4Np8CFtd0eV7w4vhRWsZr/J0nQnRr0dUDCPO53XhA4wi4pfYYlM6ZUkg850rTQuKZnatrgisN4WE+Icp8jxljrUAP9sP3PZ6zpIdnJ3oJgNIJigOwEGFxBkxIfAFt1df9AW3yqDoXGG+rKvfauZBpCoenkPgTey5L8LhH65LG4U41C1GnsfllXm08hzH6i3H7LG1LNawHOxx3h8cN5zjnVEUfbqYHVZA3q/U+uNXo9aLb+X6qDNzB7z3W5ZCXNvCXexXxb+d+KhQv1Od9CdZN9caV89LUNqXvy95sQ1++E9/HZaQlsuqzdE17p8er6A1/AAyCoDgACxMWZ4CExG+gruu31fBuGIyq76HUFBzvVUWEtD5tUPZ8yHSUw9iL+1Od0TFnc4hjvg1fP+l5v5xVG4/Lv21wfF5xfLPH7Tq+MG7fDGwfO4zDv3FUHd6cSxMIy8MtdXnMGMfl/hp/30fdvXptVdsugl4bHc35hL4gEykUF5fP8ce0jArYpBQS9x20+DEC53RdOmzD8Cw+p2y0wkqOhela9E5cvrRv1qD/fZb6602PVzGd/73VUwAMwX80AQA3kUKzz5uHVdXvJ39hGYTEbydVFX8/wO2eVzJOAdRpNQuspCBHs87qoG34dRyXrfYzxxtJKZSx1/78T0b9P0S5VaXfbJeddrxU7Vidtvva2c9xzE7XOGbTOB1Vs5DZfPwOWfq+dOwdoDTu4niYDPgcY+oBCbi14w6Pn1vrnAcKm6xVU60/tD2fF671+CP0Bf334vhROtak6uHPCtqsvfj9M9G7FCY9+PCm0G3zwCJ9MX+75dmxMR4j/4if+44pvZ3D7FT9v1942D4sDADFExQH4MbasHgKVL3UGhRKSPyW6rqehBDSxbnxgJthVLWh8fSH2B4p+JyWv9vPk7uGx9tA+Ebbzr+3v7OENj8LiZ5rHxfo+u1xAdtwfty8bMdX1Y7VtP9Nq+8PLDQX/r+XjuW20vrmFb9nPl7nCz/aXefDNfTOh2q4QfF93Q+31lTdXZtY5/xbxdX1Sg8gdBHIXPf80H4FPdYGxNN30Z9VWQ+oT15vfVK582b60v9TXXG19PBVHLfpelJpb4U7NWfI3rjq9k1MqzwHS/Pn9+cC443u7s08ZqfKo6iUa3IADIagOAC3cjA+evW8eTithlk5mLIJid9dqgb9RTN8M69i/M2FIGqSvk8vq56dqgyfvxk0Ln3fqev6/GveT+w+/dSGoZ8UPm4venlJO9gZludtHP9uPA5YqqjdvpVjNLBNd9Md7iAFAV4cPxrCph7r7bUaynmI/Qp6qOCAeJJC4q673lwvgsfeQrGQD1V5QXHVdunL8TGNrdEV//M4LfHfNJXAeB/6Ks1jcnjDwr5jGwBDIigOwK0djI8mz5uH6UdhcUqxm/ZrzXA3KegbQkiVgZ5pjV/a1AQ/SCHRi+Mvm5sQqcr7hZB76Z7YZVmiVJ19TzMQvavKfVX3VQ5V0oc7a6ryH6hsdPP6tBVBp1XhDy/F7fSgEvRI4QHxREicQZzfFXhO+1G33lrx88k1+2OBf5POCwXGu53PpMzATgarmq7FecMJAIPymyYA4C7aUO2DKqMwH1xBSHy50uvappqBBR1eFhLNLHi9MbA+27LbsiRpDvlUM9Aa4lzsnW6HOyu9KvL09dYnb9pZv6b0czBdDP3w4vjRqA1Vfa1mb7ISEodMtZVpS5q3TT1Ydrf20wRLNb7hv/0cj69pUfBkffOZ9KbhnUxW+Z23JQAwNILiANzZwfgoXfjarlz0IE/pQsADIfHlaitjugHEIk7sK1lygZ1leRqPGeaQnJ8/DGlO1gzsbRSwsrFk+1iBY9sHrFIKrsXlr2oWEN+pyn0AXUj87n7vwTo4b19cSQ8DC4mXIfuCHymEXN3uDa3juPwV//9f47LTvr2DFcxp4seXKp+36KaHYF7pOQCGRlAcgKVow+KpsrigAzk5e8ih3X9Zsrqum8qr21hgDLbBwKs0mWzLYC4yhxCeVMOroM5q7LbHCjjvg20FbmIArxMX6O1G6fuV4Bd0oK22+SoF1uIfU0i89IewhcSXY9SDdZjqhkEeY52z0hd3PV6m79Gzt3fEY/CbNnjO3ec1G+1Db2nJ6X6BuQkAgyQoDsDSHIyPUtAvVRafaA0y0FRC4itX1/Ve5QESLpeOGU+vCYnnZHNAfffY7ssSTOL4N2fksrlDmqNNh3AcNAZg6ed3pRLo7cDrrU/Tgo9H03b7gDVoQ1SpiunnalY9/GXVj+Dvqu0LiTPQOcRpIfO3k7gtruvf8bxfEyzNsqqipzDzs2oWGP+syvid5jfP2nlNbg+9HQ7gYXMAuNR/NAEAy9SGxXefNw//jp9vtAg99Tbuq3uaYW2eVrPXzrngxtzZg0V1XU8X+LfphsRYk/XKE03AHaWQuMAAv/JuAOcS73QzLNVxoXPGkzZsRDeauOwUuF0ePoAVa0Nn6dz58UDPoXfj8WtiT2DAPhYw9lUTv7u/K9dRl3lMXbZxu6QK42l+/EGAeKH+SH2RrtmNMlz9swyDXgRgqATFAViJg/HR2+fNwxTuy+11U5QtXQTYi/vnRFOsTwoDhxB22+8DmIfEF61I879Mtuu/Q+i8OJafOK5zR0LiLLSfVOUHxc1HYbnSjf2XBW5Xo2s79Xeh23Wsa2H5Xhw/Sm8aG1ezcPh4oM1wFsB6vfXJAynL1Yf9aaobbjw3fV/ANuA7ZAjrn65176QlHsun7b7/QUX9n+Y5qY3+yHx/2vUgNgBDJigOwMocjI+a583DB9UsHLqpRehYuqizG/dLF3c6UNf1YQhhvyozvMHibhoST6aZbNtQjnOP7cbcgZA4i84bTuO8YVKVWcV1PhamehqWJ93Ef3H8KM01S3ug7aPe7VRT6HgR/IIliMedUTULS221n6OBN0ma3z4VrCvWP5rgRsfa07ZCca7VpA/jNjhnpS/WeT06HcufpaUNjafzgY9DnT+fq+b+soB5zsR5EABDJygOwEodjI/SifSD583DN+3JNXQhnfynkLgnxTtU1/WrEMLvVbmhL37t7GGNG4bEk6mm6xWvS+W2hMS5qY8Fzxm8whtWoyltruLV5523f4kPIAhHwC21FcPTIhj+s3StZ1uVTvjpnPZJxusOfdHVOErH+Z1qVmn8tD3fTG/mKf5BinbO82fb9iWcC6V5yp6hBMDQCYoDsBYH46O9583DdAL9viqvwhf9lS7e7Mf9762m6IcUEgwhzG+sMRxnNwxThdhb/H+nmWzjqPROjGO3lAvDrJ+QOLeZM6S3kUwL/H49idvW6GFYiXTNoaSguEBvPzSF7VfHuhSudy4Ufr/9HGuVq8/3Xm99cr63un3RdZi853LvM1zvU/PQpc4jvWH17sfjPnwPzitrp+XNuWrjaW7dlBAcb9v6j3YbRwXtRuk7bdfDbAAgKA7AGh2Mjw6fNw9TWDBdHBtrEVbsrHpx3O+87rR/tuPyuRIWH4omLk9vGRJPQcFpCCGH7RwNoC8f2525BSFx7iLdnC7trUTvdCusdN5ZEoHe/vTDE+OEgfnjxfGj/8bPf6rZ9bVpiZUz4zaO2nP5+ZIqhacgmOtVi0nXefbivjHRFCvVl/1xqituJoUS4/fMYYbziEOByvKkEHB6W06Oc5KerleaN+y0S3Wu4vjf7edJ38dROw8at/OfkgvE7GW67wPA0gmKA7BWB+OjafzYft48fFV5kp7VeZuq2GuGfkqB4RCCsPgwLCsgWtrr3nP1RBNwQ7vxO2CiGbiDD1VZQfFTYwJWJ938bW/QlzJvbPSqfliyqZAECxpdnIPF79f5ufl8H0qf/zv38+mFfW3a1cpfqD46qr4/2H2//fvzf8ftnBXo8J0yKFNNcCsfq/yup33UbUXK9RxpnFH7ziuOv2znI/N50/G5OVQnAfI2FH7+bSnjahj3W956oA0AvhMUB6ATB+OjV8+bh/NX7wmKsizTalZFvNEU/SYsPgjLDIimi6jjvm9w3KfHcZuL/P6J21ZyVRGWL93weFrqeGCt84WT+P2T5nejQjZJNXFYvXTsKeHhNoHenijsAQRzM+5q49y5+S/P0dtg+Tr2QxXA1+9tXPZVHIaFzO+B5TQHPdRt9MG5cHPu86bxJXOk+UN202r2Bpef5khxLDYLttP5//6o+n4NbehvSpnENlRQDADOERQHoDMH46N0IvxAdXGW5OwmRdyv3KTIhLB4sQREy/RYE7Cgk/Y7YKopWJJ0k7qUquIT3Qkrl6q1lRAUN5fuX3+UsF+pEEofjDVBttL1nl0h0rVzzTRj6YGKF8ePDjOaRxjfyzXVBHdS8tstL/tu/+E++S8euuN66fq0kDgAXPCbJgCga6m6ePx4ULkRyu1P+LfjfrQnJJ6fFBZP/Vd9f3UxeUvf4/dWEBI/zmT7S75598TuzQLSQ1vbQuIM9BhwnYmxAWubj/ruY9n+Nj6AgUvh0XtC4p3oyxstnMvcXk4Pan3QXcsTvzP7NG5yvG69ZS/iFs7uGXvzCQD8TFAcgF5I1cXjksKi6QlfJ28sIu0nqYL4g7g0miNf58LiE62Rtf3Yl9ttfw7VRokbFUIYl7ptLPWYnKqI7w38O4DVzBNKCaO44Q5r8Hrr0/wV3rkTxOuXpoRtEJYAbnuuF78/nvoOGfwca6oVip/XnbRzacqU1bXdF8eP0voqXMKNv8cqIXEAuJKgOAC9cjA+SpUo71UCo/xaurj6oK1GTwFSsDAuu9WsGi15mVazCsKrHI9NJm3xe6F9nC6w7lce5OLqY/K9gsK89FOT+fqfrOBtG0DB3xlubPdL7I8SvsM/6knghs6u06si3rn/aoLs5xFpXpfDOPJwM30iJM6Nz6MrIXEA+CVBcQB652B8dBqXFBhNFYYbLcLFE/24fzyNy1RzlCdVo40fafy7mJOHdNPwgfDbN6NCx+Vp+yDAg8qDXHw3ryL+VBVx1jQHzNk7XQhrdZz5+gv09lNj/YEBzb1T0GpP2KoXNjVBEXIIYXsoZDV8j97OlibgFnMX4w0AfkFQHIDeOhgfNXFJYfEUGp1qkUFL/b8b94dURbzRHGWr63pSzR4U8arLfo/JVEV8b00B0Vz2hVHhY3PaVv5Pb/5w82jY0ve0KuKs0z85HzPbuQ2wPo31ZwVyfgBh+nrrk/Nr4Drp+k4Khz8o5E0KLPE4ognupq3M3+cA42FcR/28Gn2Zg93PrN1UFOcmY0xIHAAWICgOQO8djI8mcUmhtFRp2InesKT+3o9LCohPNMdw1HV9dnGnUr24j/Zj/9xbZxXxjKoVjwYyPlPo8Wk7RgWFhyWN+/SQyK4q4qxZzuE2r++GNWsDsbkep06F83o9D7LuQKnSG+PuxWPQW03BJaaaYCn6fA3NG23Kt5HLir44fjTOaX3p/HtVSBwAFiQoDkA2DsZHZxesq1lw2Elf2eYB8Xux31/FRX8PUAohttWLnxrzvdBUswrCrzr6/dMcGimEsDmgMdq0gfF0bJ4YIkVL4y+Fw7fX+ZAIFELYBrqbu1pvlibzAL/wF3CVdC6fAuJ7Qla9NdIExejr8TiNfYUg6JPHmoBF5jBx7vLU/AUAFicoDkBWUmA4BYcrgfFSCYjzk7quD9sx74J1N86qu7cB0WmH6zHNpL02BjhGp+1DHY7N5Unjbrd9i8BEc9ChcabrPVF9HzpzbL1ZgcZ6AwV9nz14vfVpNy5TzdFrI01QhjjW0rXtPp4fHgpa0jNPNAHXSPOXXc0AADcjKA5Ali4Exvcqrz/MXeo/AXGu1FYXT5WLt433tY7LFBB90JMKwrl8L4wHPE5TYPxVXP4v7TvV7CED8h7/AuL0xf1M13tf10FnmkzX28Ox/ZZjkL8R/gIuHB+34/dCWpyzc5NrBJQ71/PmkdXqy3dtFm/BfHH8aFR5QIarpfOa9KDbRFMAwM39RxMAkLM2UJxe5/72efNwJ37+WWVywYMz6SLZu9iPTupZSBtYvhdCeNWO9w2tsnTTuOz3MBz6d5VHNZH/2oXOxmrafyZxrG62Y/WJ8ZrPcVk4nB4aZ7jOTcdv4oBBS+G3F8eP0hgc5TQPV9U1i7lSboS/gCSd432Ix5lGU3AL/2iCpR6Xd3o2//Sg4mr9ryfrkct1WdXEuUqawzz1ECwA3J6gOADFaMPGk+fNw3H8/KPq1wU3fpT66kPss0ZTcBupanEIIT0k8jIuz7TIUkyrfgbE53K5AOhhpR/HagrTpOriu3HMpuPy48oF/94el3vy9gD4QfzuyPVBE9XEoXtNZtcFHIf1kXUGVnGut+9BpDy9OH401gplSaHs2K+nPTrHFRKnbx5rAi6xF78/32oGALib3zQBAKVJ4eO4pFDa/6WTx8qrEfti2vbH/6X+ERLnruq6Po1L2qfuVbMbX9xOGotPY1ve63kV4Vyq9wmKXz1mJ3F52h6f03HazaieHJdjv+wKidNjOd4kPDGmoBeOM1tflZ97rq1el1NV8dNUXV/PwSDP9dJDi/8XvwN2hcShd/p0PeyD7qBn0jXjRjPQSucyD4TEAWA5VBQHoFgH46N0Ay+dPL593jxMwb0/q1kV0w2tszapD9KFT9XDWZm6rqfVrFpxugm2045143yxsbnfth/LsxH3xY30IIOmuHLMpraZpCW1VXtsTkHQsbG7ctP5cbmt9g691n5H7GS46u/0HvRCY31ZUT/l8nCoBzNheN9PH15vfZpoCpZsqgmW6mNPznNPPFA2rPHz4vjRZt/7vH24aTuuaxoj6W2yI7vQYKU3orzSDACwPCqKAzAIB+Ojk7aKdapimqqZTqpZUJLlmwcAn6b2Vj2cdUmB57i8qmYVxlPlCRe6f5aCAqly8LyC8DSj/s3pe0RV8cX79XReaTztl/GvtqvZQ17G7/JM2zZ90L45YE9InIzs5Djmev6GDhiMNmSQy3z3pK1WTf8dW1egR+aFUu7F48i2kHhxRn05x9EVS52jHlb9uDelmvjwxs9GRuMkHc8eVLM3ZDhPGpamnde80hQAsFwqigMwOAfjo3Qh7iws+bx5OK9iqtL43cyrE39s2xc6c6FasbcJzAK36cL/Ye7Vw+P61/bw4sdvU7XVNOP4HVWzKuNb7edICy0stWGqUNUIhZO5PzNcZ9XEoX/HxJ0M1vOjrspqn8qF6zNQrrM3RbWBU8o10gRFj+GdHqwD9Fb7IO2rF8eP0gNRzypvki3dNC575jYAsDqC4gAM2oXQeAqUzoPjqsFeLwXP0s3sw1SxXXPQR21AMlUX3w0hDOnBkPS9lqrHZR8OZ9DjN+27k3ZJwfE0bsfVLDi+2f7MTNOO+ZPYbi6mU4T2uD3KbLXnD6sB/ZGOjzuZHMvJQAqsvDh+dFL1/7qRKvVQnvTdkx5KPDS+IXsfO56jHrZv34Es5t+VwHjJUv++U0EcAFZPUBwAWm3YOS2vnjcPz4fR0qfg+Kxtmmp2o72J7eWGBFlpw5NnD4aEENK4flzQ+P42PoVEKXgMz99e8W0fb98akJb77WdaSr9RkMb7tPoeDG/sHRQqy2ri7XcV0B85HCdPX299cjzPbz7W9/NIVeqhnO+bs7fECXXSIfvekqWKuS+OH6Vzx66uYZknDNNmlfEDqhcC4zvV7LrRSLdm6ywgHpe3HoADgPUQFAeAS7Qh6G9htDY4Pq9eer/9LDmIlra/icvf7eeJYDglaYOVacmxSnEai+lG4XH72QilMeCxPH/I65t2TM9D47+3n6MqvxsH0+p7IPzsZ6FwhqJ9oGuc4aq/1XvQLylU9+L40bTn8wDH9/zkUKneA8SQrzR+U4izEQ4fvPt9mU/pipWYVLPqyOt2ap6w1vHTxPORvqzORiFtmvbhdP3lbWzb9Da6P6rZW2TJg4A4AHREUBwAFtCGpJvq3A3cC+HxFEQbVXkGWtI2TePyTyUUzgBdUaV4XH0Plm5V3YVML47PFBSd6jW4dkz/cMw+N7bnY3l+DE/uV99vlKzrOD6tvlfkSkH3/537O+McZjf5cjPx4Bb0+px3p8frd6yLstyn+ixVqT/RTZCNafu9Mg+Hm1Myt6EJipbeFtBFUPzQ9wylSNX50z794vjRqD3nS9eTRlqmt/OdFBCf+A4CgG4IigPALV0WHk/OBchH7TIPkSfjDla1OXcS/k/1PYgmEA5XuKpqbwghje2N6sfg+Pkxft783ybzKuAXpb//++K/UTUYVja258fA5JfVk85VJr/K+TFeVT+Gv38a6231c+Aa7QMdOxmu+r7eg97qe/VnFR0zk0GlevsU9Nv8mnI6Ph2q1gyDnU+cdDSf+Kj1KXF+Hj9epSWOq3TN9s9qVmXcAzfdS3OeD7GPJpoCALolKA4AS3YuQH6lc2HyuevCaNdJ4bPzoW8hcFgBQU8Y1Hi/7njeaCVYiZcZrvPEmwCg1/p8zJ4KCGa9X+30dN1UqYd+OR8Mb1T85wY2erL/sjrp4a51VhWfthWYGab7Q9jI9ji7m5YXx49SWPxxJTTexbFjEpd3zncBoD8ExQGgA1eEyV2gAwBgsDKuJv5O70F/9bz6c6OHstXnSvWuL0G3Ttrv9/QGuUZAijvY7Mn+zOp8qNYbFDdH6G4c9WE8Dy4o3T4YkZbdttL4H9Xszc+bdsulO23b+qMHUgCgnwTFAQAAAOiDHKuJN944AnmM1aqfod6PuibrfaqPTl5vfVL9Fdb7XZDmgv+046/RJMCiUuXjF8ePUqByXQHeD1q9E+ZmPRlv7TG7iuNuVM0C44/bT9XGb79vC4cDQCYExQEAAADoVMbVxPf1HmShr9WfG12Tpx5XqvfwQb7Oh/dGVT/fgjBk6fs6haFSlfCzoJlK4cCS5hRPtQKsfy4fPybtUrXVxsdx2aoEx68zf3PKRw/IAUBeBMUBAAAA6Fqu1cQbXQdZSNXNpn1bKZWfs5eCXX0LkXjLRabi98GkasNKcy+OH6X9a7P946j6Hh6/f27fG2u9pThtx888DD5tF1X66dJ2T8YGcDd7PZkzGs9Xz8Pm1cbftnOwzXYOdr+da20OuHnmwfD08HVjXgQA+ao1AQAAAABdaauJf81w1bcFxQGAvmhDTfMg2vmQefLf6ueQ03gAzTIPgM9//rv9eR4Kn6oMDgAsMM8at3Op39vPEudR03aOlOZLTeWBOQAoiqA4AAAAAJ0JIbyPHzuZrXaqJr6t9wCAklwIm593MXh+lfvV6qqmHl/x9/PQ97c/CzUBAGuYN42q2Rtf5vOnrRvMmbo0nzuludW0mj041+hRACiboDgAAAAAnQghpJtnXzJc9ad1XR/qQQAAAADOe3H86HxgfNx+pmrko/bnVQTKp+2SeJMKAPADQXEAAAAAOhFC+Fzl97reaV3X9/QeAAAAAMtwrkL5IoS+AYAbERQHAAAAYO1CCOP48TnDVd+t63qiBwEAAAAAAOg7QXEAAAAA1i6E8LVavFJSX6gmDgAAAAAAQDZ+0wQAAAAArFMI4VWVX0g82dd7AAAAAAAA5EJFcQAAAADWJoQwih9f4rKR2aqrJg4AAAAAAEBWVBQHAAAAYJ3eVPmFxBPVxAEAAAAAAMiKiuIAAAAArEUIYRw/Pme46qqJAwAAAAAAkB0VxQEAAABYuRBCqiL+PtPV39ODAAAAAAAA5EZQHAAAAIB1eBaXUYbr3dR1faj7AAAAAAAAyE2tCQAAAABYpRDCZvz4kunqb9d13ehFAAAAAAAAcqOiOAAAAACr9j7T9W6ExAEAAAAAAMiVoDgAAAAAKxNCeBU/NjNd/X09CAAAAAAAQK5qTQAAAADAKoQQUkD8S6arn6qJb+tFAAAAAAAAciUoDgAAAMDShRA2qllIfJTpJjyo6/pETwIAAAAAAJCr3zQBAAAAACvwpso3JD4REgcAAAAAACB3KooDAAAAsFQhhCfx46+MN+FeXddTPQkAAAAAAEDOVBQHAAAAYGlCCKP48T7jTXgrJA4AAAAAAEAJVBQHAAAAYGlCCF/ix2amq39azaqJn+pJAAAAAAAAcqeiOAAAAABLEUJ4U+UbEk/eCYkDAAAAAABQChXFAQAAALizEMJO/Hif8SZM4/JAUBwAAAAAAIBSqCgOAAAAwJ2EEFIV8TeZb8a+kDgAAAAAAAAlUVEcAAAAgFsLIWzEjy9xGWW8GU1d19t6EwAAAAAAgJKoKA4AAADAXXyu8g6JJ/u6EQAAAAAAgNIIigMAAABwKyGE9/FjM/PNmNR13ehNAAAAAAAASlNrAgAAAABuKoTwLH68yXwzTuPyoK7rqR4FAAAAAACgNCqKAwAAAHAjIYSdKv+QePJOSBwAAAAAAIBSqSgOAAAAwMJCCJvx43NcNjLflGk1qyZ+qlcBAAAAAAAokYriAAAAACykoJB4sickDgAAAAAAQMlUFAcAAADgWoWFxJu6rrf1KgAAAAAAACUTFAcAAADgl0IIKRyeQuKbhWzSvbqup3oWAAAAAACAkv2mCQAAAAC4SoEh8X0hcQAAAAAAAIZARXEAAAAALlVgSHxa1/U9PQsAAAAAAMAQqCgOAAAAwE8KDIknu3oWAAAAAACAoRAUBwAAAOAHhYbEJ3VdN3oXAAAAAACAoag1AQAAAABzhYbET+Nyr67rUz0MAAAAAADAUKgoDgAAAMCZEEIKh3+tygqJJ7tC4gAAAAAAAAyNoDgAAAAA85B4qiS+UdimHdZ1faiHAQAAAAAAGBpBcQAAAICBCyHsVGWGxFMV8T09DAAAAAAAwBAJigMAAAAMWAjhWfx4X5UXEk/267qe6mUAAAAAAACGqNYEAAAAAMMUQkgB8Z1CN6+p63pbLwMAAAAAADBUguIAAAAAAxNCSNXDP8dls9BNPI3LvbquT/U2AAAAAAAAQ/WbJgAAAAAYjhBCCod/rcoNiSe7QuIAAAAAAAAMnaA4AAAAwECEEHaqWSXxjYI387Cu60O9DQAAAAAAwNDVmgAAAACgfCGEN/HjWeGbOY3LA9XEAQAAAAAAoKr+owkAAAAAyhVCGMWPv+KyOYDN3RUSBwAAAAAAgJnfNAEAAABAmUIIT+LHl2oYIfH9uq4bvQ4AAAAAAAAztSYAAAAAKEsIYSN+vIzLs4FsclPX9baeBwAAAAAAgO8ExQEAAAAKEkJI1cPfV8OoIp6cxuVBXddTvQ8AAAAAAADf/aYJAAAAAMoQQngVP75UwwmJJ7tC4gAAAAAAAPCz/2gCAAAAgLwNsIr43H5d14f2AAAAAAAAAPhZrQkAAAAA8hRC2IgfL+PybICb39R1vW0vAAAAAAAAgMsJigMAAABkKITwJH68ictogJs/jcuDuq5P7QkAAAAAAABwOUFxAAAAgIyEEEbx431cxgNuhhQSP7E3AAAAAAAAwNV+0wQAAAAA/RdC2IhLqiD+tRp2SHxXSBwAAAAAAACu9x9NAAAAANBvIYRX8ePPuGwMvCne1nU9sUcAAAAAAADA9WpNAAAAANBPIYSd+PEyLiOtUR3Wdf1UMwAAAAAAAMBiBMUBAAAAekZA/Ccncdmu6/pUUwAAAAAAAMBiBMUBAAAAekJA/FIpHH5PSBwAAAAAAABu5j+aAAAAAKA7IYSN+PEsLn/GZUOL/CCFw1USBwAAAAAAgFtQURwAAACgAyGEUTWrHv6kEhC/SgqJN5oBAAAAAAAAbk5FcQAAAIA1CiHsxI8/4jLWGr+0KyQOAAAAAAAAt6eiOAAAAMCKhRA2q1k4fKdSPXwRKSQ+0QwAAAAAAABweyqKAwAAAKxACGEUP57E5c+4jLTIwvaExAEAAAAAAODuVBQHAAAAWLIQwk78eK8lbmxS1/WuZgAAAAAAAIC7+00TAAAAACxdowluTEgcAAAAAAAAlkhQHAAAAGDJ6rqexo8TLbEwIXEAAAAAAABYMkFxAAAAgNX4qAkWIiQOAAAAAAAAKyAoDgAAALAah5rgWkLiAAAAAAAAsCK1JgAAAABYjRDC1/gx0hKX2q3reqIZAAAAAAAAYDVUFAcAAABYnUYTXEpIHAAAAAAAAFZMUBwAAABgdT5qgp8IiQMAAAAAAMAa1JoAAAAAYHVCpBXOnMZlu67rE00BAAAAAAAAq6eiOAAAAMBqHWqCaloJiQMAAAAAAMBaCYoDAAAArNbxwLc/hcMfCIkDAAAAAADAegmKAwAAAKzW4cC3PVUSP7UbAAAAAAAAwHoJigMAAACsUF3X02pWVXto3sZtfyokDgAAAAAAAN0QFAcAAABYvWZA25qC4bt1Xe/pdgAAAAAAAOhOrQkAAAAAViuEsBk/vgxgU6dxSVXET/Q6AAAAAAAAdEtQHAAAAGANQgj/xo+NgjfxsJpVEj/V2wAAAAAAANC93zQBAAAAwFocFrxt+3VdPxUSBwAAAAAAgP4QFAcAAABYj48FblMKhm/Xdf1K9wIAAAAAAEC/1JoAAAAAYPVCCBvx49+CNilVSN9VRRwAAAAAAAD6SUVxAAAAgDVoA9VNAZuStmMvbs9TIXEAAAAAAADoL0FxAAAAgPX5mPn6N3F5UNf1W10JAAAAAAAA/SYoDgAAALA+h5mu97yK+HZcproRAAAAAAAA+q/WBAAAAADrE0L4Gj9GGa1yE5ddAXEAAAAAAADIi4riAAAAAOuVS1VxVcQBAAAAAAAgY4LiAAAAAOv1MYN1nMTlXl3Xb3UXAAAAAAAA5KnWBAAAAADrFUL4N35s9HDVTqpZFfFGLwEAAAAAAEDeVBQHAAAAWL/Dnq3PaVx267p+ICQOAAAAAAAAZRAUBwAAAFi/456sRwqI78flXl3XE90CAAAAAAAAAAAAAHBLIYSN0L33cRnpDQAAAAAAAAAAAACAJQkhfBYQBwAAAAAAAFblN00AAAAA0ImPa/59k7jcq+t6Ny5TzQ8AAAAAAAAAAAAAsGQhhE0VxAEAAAAAAAAAAAAAChNC+LqicPi/cXkVlw2tDAAAAAAAAAAAAACwRiGEN0sOiH+Oy46WBQAAAAAAAAAAAADoSAjhyZKqh7+Py6YWBQAAAAAAAAAAAADogTbofRt/qR4OAAAAAAAAAAAAANBDbeD7RuHwuGxoOQAAAAAAAAAAAACAnmqD31dJ1cbfC4cDAAAAAAAAN1VrAgAAAIDutAHwf9s/TuNyEpfjuDR1XZ9oIQAAAAAAAAAAAACADIUQxnEZaQkAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADW4/8FGAD+lxz3BykGxAAAAABJRU5ErkJggg==";
      logo = $('#logo_wdms').attr('src', logo_base);
  };


  $.fn.adminSite = function (options) {
    // noinspection ES6ModulesDependencies
    var opts = $.extend({}, $.fn.adminSite.defaults, options);
    $.extend($.fn.dataGrid.defaults, options);

    opts.used_skin_layer_id = undefined;
    opts.used_skin_layer_shade_id = undefined;

    layui.config({
      base: opts.base_path,
      version: '1.8'
    }).extend({
      zkMenu: 'zkMenu',
      zkTab: 'zkTab.min',
      autoColumnWidth: 'autoColumnWidth.min',
      tablePlug: 'tablePlug.min'
    });

    $.fn.get_action_cache(true);

    layui.use(['element', 'layer', 'zkMenu', 'zkTab'], function () {
      var $ = layui.jquery, element = layui.element, menu = layui.zkMenu, tab = layui.zkTab,
        side_menu = $("#side_menu"),
        main_body = $("#main_body"),
        dash_board = $("#dashboard"),
        subscription = $("#subscription"),
        guide = $("#guide"),
        $group_list_str = '#side_menu_nav>li';


      menu.render({data: opts.menu});
      tab.render({pin_tab_url: opts.pin_tab_url});

      element.on("nav(nav-menu)", function (elem) {
        console.log(elem);
        $.each($.fn.dashboard_timer || {}, function (key, val) {
          if (val !== null) {
            window.clearTimeout(val);
          }
        });

        var $elem = $(elem),
          $menu = $('#side_menu .zk-switch-menu'),
          indent_button = $menu.find("i.fa-indent"),
          tabs_of_last_module = $("#zk-layui-tab-ul>li"),
          module_name = $elem.attr('app'),
          nav_header = $elem.closest('.layui-header.header'),
          header_popup = $('.header-popup-layer.level-2', nav_header),
          tag_a_rect = $elem[0].getBoundingClientRect();


        if (module_name === undefined) { // it is non-app
          header_popup.addClass('layui-hide');
          side_menu.addClass("layui-hide");
          main_body.addClass("layui-hide");
          dash_board.removeClass("layui-hide"); // .remove();
          subscription.addClass("layui-hide");
          $("#subscription_btn").removeClass("active-subscription");
          setTimeout(function () {
            $('.layui-nav-item .layui-this').removeClass('layui-this');
          }, 50);
          window['del_local_storage']($.fn.adminSite.const.LAST_SESSION);
          return true;
        } else {
          header_popup.removeClass('layui-hide');
          set_arrow_offset($('> .desc-inner-arrow', header_popup), tag_a_rect);
          set_arrow_offset($('> .desc-outer-arrow', header_popup), tag_a_rect);
        }

        if (indent_button.length) {
          // indent_button.get(0).dispatchEvent(new Event('click'));
          indent_button.trigger('click');
        }
        $($group_list_str + '.layui-nav-itemed').removeClass('layui-nav-itemed');
        $($group_list_str).hide();
        $($group_list_str + '[app="' + module_name + '"]').show();
        side_menu.removeClass("layui-hide");
        main_body.removeClass("layui-hide");
        dash_board.addClass("layui-hide"); // .remove();
        subscription.addClass("layui-hide");
        guide.addClass("layui-hide");
        $("#subscription_btn").removeClass("active-subscription");
        // delete the tabs of last module
        $.each(tabs_of_last_module, function (i, t) {
          var layID = $(t).attr('lay-id');
          tab.tabDelete(layID, {
            record: false
          });
        });

        // fetch and parse session data
        var last_session_obj = JSON.parse(window['get_local_storage']($.fn.adminSite.const.LAST_SESSION) || '{}'),
          archived_session_obj = JSON.parse(window['get_session_storage']($.fn.adminSite.const.ARCHIVED_SESSION) || '{}'),
          is_auto_triggered = elem.data('is_auto_triggered'),
          using_archive = false;

        if (Object.keys(archived_session_obj).length) {
          last_session_obj = archived_session_obj;
          using_archive = true;
        }
        var last_module_name = last_session_obj.module,
          last_tab_ids = last_session_obj.tabs,
          tab_ids = [], amount, load_msg;


        if (is_auto_triggered) {
          if (last_module_name === module_name && last_tab_ids && type(last_tab_ids) === 'array' && last_tab_ids.length) {
            tab_ids = last_tab_ids;
            load_msg = gettext('loading tabs from last session. %s / %s');
            if (using_archive) {
              window['del_local_storage']($.fn.adminSite.const.ARCHIVED_SESSION);
            }
          }
        } else {
          var module_sub_menu = $('#side_menu_nav > li[app=' + module_name + ']');
          (function (result) {
            module_sub_menu.find('dl>dd>a[class~=pined-tab-item]').each(function () {
              result.push($(this).attr('hex'));
            });
          })(tab_ids);
          load_msg = gettext('loading pined-tab. %s / %s');

          if (window['get_session_storage']($.fn.adminSite.const.TABS_RESTORE_NOTIFY_ID)) {
            window['set_session_storage']($.fn.adminSite.const.ARCHIVED_SESSION, last_session_obj);
            // console.log('set session storage: archived session');
          }
        }
        window['del_local_storage']($.fn.adminSite.const.LAST_SESSION);
        amount = tab_ids.length;
        if (amount === 0) { // first we try to find the 'pined' menu item
          var first_visible_menu_item;
          var visible_menu_item;
          if(module_name === 'personnel' || module_name==='acc'){
            visible_menu_item = module_sub_menu.find('dl > dd > a').children()
          }else {
            visible_menu_item = module_sub_menu.find('dl > dd > a').first();
          }
          visible_menu_item.closest('li.layui-nav-item').addClass("layui-nav-itemed");
          first_visible_menu_item = module_sub_menu.find('dl > dd > a').first();// only click the first
          first_visible_menu_item.click();
        } else {
          var interval = 1000;
          for (var i = 0; i < amount; i++) {
            var _tab_id = tab_ids[i]
              , _item_str = interpolate('a[hex=%s]', [_tab_id])
              , _item = $(_item_str);
            _item.closest('li').addClass('layui-nav-itemed');
            setTimeout((function (elem, i) {
              return function () {
                // var lay_idx = layer.msg(interpolate(load_msg, [i + 1, amount]), {
                //   title: 'Info',
                //   icon: 16,
                //   shade: 0.01,
                //   time: 0
                // });
                // Mutable variable is accessible from closure
                elem.trigger('click');
                // setTimeout(function () {
                //   lay_idx && layer.close(lay_idx);
                // }, 800);
              };
            })(_item, i), interval * i);
          }
        }
      });

      element.on('nav(system-menu)', function (elem) {
        var $elem = $(elem),
          elem_rect = $elem.get(0).getBoundingClientRect(),
          ref = $elem.attr('ref'),
          event = $elem.attr('event'),
          menu_text = $elem.text(),
          load_index;

        switch (event) {
          case "license":
            load_index = layer.load();
            $.ajax({
              url: ref
              , type: "GET"
              , dataType: "html"
              , success: function (panel) {
                layer.closeAll();
                layer.open({
                  title: 'About the system'
                  , type: 1
                  , zIndex: 1001
                  , area: ['620px', '490px']
                  , content: panel
                });
              }
              , error: function () {
              }
            });
            break;
          case "changeLanguage":
            load_index = layer.load();
            $.ajax({
              url: ref,
              type: 'GET',
              dataType: 'html',
              success: function (response) {
                layer.close(load_index);
                layer.open({
                  type: 1
                  , area: ['400px', '250px']
                  , content: response
                  , title: menu_text
                  , btn: [gettext('btn_confirm'), gettext('btn_cancel')]
                  , yes: function (index, layero/*, callee*/) {
                    var data_form = $(layero).find("#id_lngForm");
                    var data = data_form.serialize();
                    $.ajax({
                      url: ref,
                      type: 'POST',
                      data: data,
                      dataType: "json",
                      success: function (response) {
                        if (response.code === 0) {
                          layer.close(index);
                          window.location.reload();
                        } else {
                          parse_msg_show_tips(layero, response.msg);
                        }
                      }
                    });
                  }, success: function () {
                    layui.use('form', function () {
                      var form = layui.form;
                      form.render();
                    });
                  }
                });
              }
            });
            break;
          case "skin":
            // noinspection HtmlUnknownAttribute
            var tab_html = [
                '<div class="layui-tab layui-tab-brief" lay-filter="skin_picker">',
                interpolate('<ul class="layui-tab-title"><li class="layui-this">%(first_tab)s</li><li>%(second_tab)s</li></ul>', {
                  'first_tab': gettext('system_skin_theme'),
                  'second_tab': gettext('system_skin_pureColor')
                }),
                '<div class="layui-tab-content">',
                '<div class="layui-tab-item layui-show"><div class="layui-fluid zydeco-skin-fluid"><div class="layui-row layui-col-space15">loading</div></div></div>',
                '<div class="layui-tab-item">' + (function () {
                  return [
                    '<div class="layui-box">',
                    interpolate('<input type="hidden" name="color" value="" id="%s">', [SELECTOR_SKIN_COLOR_PICKER]),
                    '</div>'].join('');
                })() + '</div>',
                '</div></div>'
              ].join(''), _width = 460, _height = 310,

              cell_unit = [
                '<div class="layui-col-md4 layui-col-sm4"><div class="zydeco-skin-box">',
                '<a href="javascript:;">',
                '<div class="text-center"><',
                'img %(img_src)s %(img_style)s alt=""',
                '><div class="zydeco-skin-caption zydeco-font">%(img_text)s</div>',
                '</div></a></div></div>'
              ].join('');
            var current_layer = get_specific_layer(opts.used_skin_layer_id),
              get_layer_offset = function (_rect) {
                var max_window_width = window.innerWidth;
                return [
                  Math.max(_rect.top + _rect.height, CONST_NAV_HEADER_HEIGHT) + 'px',
                  (function () {
                    return (!is_rtl_layout()
                            ? (max_window_width - _rect.left < _width ? max_window_width - _width : _rect.left) + 'px'
                            : '0px');
                  }())];
              },
              adjust_popup_arrow = function (_layer, _rect) {
                var skin_popup_layer = _layer.find('.skin-popup-layer.level-2'),
                  inner_arrow = skin_popup_layer.find('.desc-inner-arrow'),
                  outer_arrow = skin_popup_layer.find('.desc-outer-arrow');

                if (is_rtl_layout()) {
                  outer_arrow.css({
                    'left': _rect.left,
                    'right': 'initial'
                  });
                  inner_arrow.css({
                    'left': _rect.left + 2,
                    'right': 'initial'
                  });
                } else {
                  outer_arrow.css({
                    'right': _rect.width,
                    'left': 'initial'
                  });
                  inner_arrow.css({
                    'right': _rect.width + 2,
                    'left': 'initial'
                  });
                }
              };
            if (opts.used_skin_layer_id === undefined || current_layer.css('display') === 'none') {
              if (!opts.used_skin_layer_id) {
                opts.used_skin_layer_id = layer.open({
                  type: 1,
                  title: false,
                  closeBtn: 0,
                  resize: false,
                  shade: [0.01, '#000'],
                  // shadeClose: true,
                  anim: -1,
                  fixed: top !== window,
                  isOutAnim: false,
                  offset: get_layer_offset(elem_rect),
                  area: [_width + 'px', _height + 'px'],
                  content: tab_html,
                  success: function (layero/*, index*/) {
                    var $layero = $(layero),
                      corresponding_shade = $layero.siblings('.layui-layer-shade').first(),
                      hide_skin_box = function () {
                        $(opts.used_skin_layer_shade_id).hide();
                        get_specific_layer(opts.used_skin_layer_id).fadeOut();
                      };
                    opts.used_skin_layer_shade_id = '#' + corresponding_shade.attr('id');
                    corresponding_shade.on('click', hide_skin_box);

                    // ---------------------
                    // for first tab `themes`
                    // ---------------------
                    $.ajax({
                      url: opts.appearance_themes_url,
                      type: 'GET',
                      dataType: 'json',
                      success: function (res) {
                        if (res.code >= 0) {
                          var carryall = res.msg,
                            base_path = carryall['base_path'],
                            available_themes = carryall['theme_names'],
                            html_buffer = [];

                          _.each(PRESET_SKIN_THEMES, function (value, name) {
                            var style_obj = value['style'],
                              style_html = [];
                            _.each(style_obj, function (s_val, s_prop) {
                              style_html.push(s_prop + ':' + s_val);
                            });

                            html_buffer.push(
                              interpolate(cell_unit, {
                                'img_text': gettext(name),
                                'img_style': interpolate('style="%s" ', [style_html.join('')])
                              })
                            );
                          });

                          available_themes.forEach(function (name) {
                            html_buffer.push(
                              interpolate(cell_unit, {
                                'img_src': interpolate('src="%s" ', [base_path + name]),
                                'img_text': gettext(name)
                              })
                            );
                          });

                          // adjust max height and make vertical scroll-bar visible
                          var first_tab_item = $layero.find('.layui-tab-content > .layui-tab-item').first();
                          first_tab_item.find('.layui-row').html(html_buffer.join(''));
                          first_tab_item.css({
                            'max-height': 260,
                            'overflow-x': 'hidden',
                            'overflow-y': 'auto'
                          });
                          $(SELECTOR_SKIN_BOX, layero).on('click', 'a', function () {
                            var _elem = $(this),
                              _img_elem = _elem.find('img'),
                              _img_src = _img_elem.attr('src'),
                              background_value;
                            if (_img_src === undefined) {
                              background_value = _img_elem[0].style.background;
                            } else {
                              background_value = interpolate('url(%s)', [_img_src]);
                            }
                            // check-mark is exclusive
                            $(SELECTOR_SKIN_BOX).removeClass('check-mark');
                            _elem.closest(SELECTOR_SKIN_BOX).addClass('check-mark');

                            $(SELECTOR_NAV_HEADER).css({
                              'background': background_value
                            });
                            window['set_local_storage']($.fn.adminSite.const.SKIN_CSS_BACKGROUND, background_value);
                          });

                          adjust_popup_arrow(layero, elem_rect);
                        }
                      }
                    });

                    // ----------------------------
                    // for second tab `pure_colors`
                    // ----------------------------
                    $layero.addClass('sp-extension');
                    $layero.prepend(
                      (function () {
                        return [
                          '<div class="skin-popup-layer level-2">',
                          '<i class="desc-inner-arrow"></i>',
                          '<i class="desc-outer-arrow"></i></div>'
                        ].join('');
                      })());

                    var update_appearance_theme = function (color) {
                      var _color = "transparent",
                        browser = get_browser_platform();

                      if (color) {
                        var alpha_value = color.getAlpha(),
                          hex_suffix = Math.floor(255 * alpha_value).toString(16);
                        if (hex_suffix.length % 2) {
                          hex_suffix = '0' + hex_suffix;
                        }
                        _color = color.toHexString() + hex_suffix;

                        if (type(browser.chrome) === 'boolean' && !browser.chrome) {
                          _color = hex_to_rgb(_color);
                        }
                      }

                      $(SELECTOR_NAV_HEADER).css({
                        'background': _color
                      });

                      window['set_local_storage']($.fn.adminSite.const.SKIN_CSS_BACKGROUND, _color);
                    };

                    $($SELECTOR_SKIN_COLOR_PICKER).spectrum({
                      showAlpha: true,
                      flat: true,
                      color: '#56c77d',
                      showInput: true,
                      className: "full-spectrum",
                      showInitial: true,
                      showPalette: true,
                      showSelectionPalette: true,
                      maxSelectionSize: 10,
                      preferredFormat: "name",
                      localStorageKey: "biotime_spectrum.skin",
                      move: function (color) {
                        update_appearance_theme(color);
                      },
                      show: function () {
                      },
                      beforeShow: function () {
                      },
                      hide: function () {
                        hide_skin_box();
                      },
                      change: function (color) {
                      },
                      palette: [
                        ["rgb(0, 0, 0)", "rgb(67, 67, 67)", "rgb(102, 102, 102)",
                         "rgb(204, 204, 204)", "rgb(217, 217, 217)", "rgb(255, 255, 255)"
                        ],
                        ["rgb(152, 0, 0)", "rgb(255, 0, 0)", "rgb(255, 153, 0)", "rgb(255, 255, 0)", "rgb(0, 255, 0)",
                         "rgb(0, 255, 255)", "rgb(74, 134, 232)", "rgb(0, 0, 255)", "rgb(153, 0, 255)", "rgb(255, 0, 255)"
                        ],
                        ["rgb(230, 184, 175)", "rgb(244, 204, 204)", "rgb(252, 229, 205)", "rgb(255, 242, 204)", "rgb(217, 234, 211)",
                         "rgb(208, 224, 227)", "rgb(201, 218, 248)", "rgb(207, 226, 243)", "rgb(217, 210, 233)", "rgb(234, 209, 220)",
                         "rgb(221, 126, 107)", "rgb(234, 153, 153)", "rgb(249, 203, 156)", "rgb(255, 229, 153)", "rgb(182, 215, 168)",
                         "rgb(162, 196, 201)", "rgb(164, 194, 244)", "rgb(159, 197, 232)", "rgb(180, 167, 214)", "rgb(213, 166, 189)",
                         "rgb(204, 65, 37)", "rgb(224, 102, 102)", "rgb(246, 178, 107)", "rgb(255, 217, 102)", "rgb(147, 196, 125)",
                         "rgb(118, 165, 175)", "rgb(109, 158, 235)", "rgb(111, 168, 220)", "rgb(142, 124, 195)", "rgb(194, 123, 160)",
                         "rgb(166, 28, 0)", "rgb(204, 0, 0)", "rgb(230, 145, 56)", "rgb(241, 194, 50)", "rgb(106, 168, 79)",
                         "rgb(69, 129, 142)", "rgb(60, 120, 216)", "rgb(61, 133, 198)", "rgb(103, 78, 167)", "rgb(166, 77, 121)",
                         "rgb(91, 15, 0)", "rgb(102, 0, 0)", "rgb(120, 63, 4)", "rgb(127, 96, 0)", "rgb(39, 78, 19)",
                         "rgb(12, 52, 61)", "rgb(28, 69, 135)", "rgb(7, 55, 99)", "rgb(32, 18, 77)", "rgb(76, 17, 48)"
                        ]
                      ]
                    });
                  }
                });
              } else {
                $(opts.used_skin_layer_shade_id).show();
                var offset = get_layer_offset(elem_rect);
                current_layer.show().css({
                  top: offset[0],
                  left: offset[1]
                });
                adjust_popup_arrow(current_layer, elem_rect);
              }
            }

            break;
          case "logout":
            layer.confirm(gettext('are_you_sure_to_logout'), {
              icon: 3,
              title: menu_text,
              btn: [gettext('btn_confirm'), gettext('btn_cancel')]
            }, function (index) {
              layer.close(index);
              window.location = ref;
            });
            break;
          case "changePassword":
            load_index = layer.load();
            $.ajax({
              url: ref,
              type: 'GET',
              dataType: 'html',
              success: function (res) {
                layer.close(load_index);
                layer.open({
                  type: 1
                  , zIndex: 1999
                  , area: ['auto', 'auto']
                  , content: res
                  , title: menu_text
                  , btn: [gettext('btn_confirm'), gettext('btn_cancel')]
                  , yes: function (index, layero/*, callee*/) {
                    var data_form = $(layero).find(".action-form,.data-form"),
                      data = data_form.serialize();
                    $.ajax({
                      url: ref,
                      type: 'POST',
                      data: data,
                      dataType: "json",
                      success: function (response) {
                        if (response.code === 0) {
                          layer.close(index);
                          layer.alert(gettext('auto_logout_after_3_seconds'), {
                            title: ' ',
                            time: 3000, //3s后自动关闭
                            btn: [gettext('btn_confirm')],
                            end: function () {
                              window.location.reload();
                            }
                          });
                        } else {
                          if(response.msg === 'Old Password Error') {
                            layer.msg(response.msg, {icon: 5});
                          }else if(response.msg.password2[0].code === 'password_mismatch'){
                            layer.msg('The two password fields didn\'t match.', {icon: 5});
                          }else{
                            layer.msg('Please fill mandatory fields', {icon: 5});
                          }
                        }
                      }
                    });
                  }
                });
                layui.use('form', function () {
                  var form = layui.form;
                  form.render();
                });
              }
            });
            break;
          case "changeCompany":
            load_index = layer.load();
            $.ajax({
              url: ref,
              type: 'GET',
              dataType: 'html',
              success: function (response) {
                layer.close(load_index);
                layer.open({
                  type: 1
                  , area: ['400px', '400px']
                  , content: response
                  , title: menu_text
                  , btn: [gettext('btn_confirm'), gettext('btn_cancel')]
                  , yes: function (index, layero/*, callee*/) {
                    var data_form = $(layero).find("#id_comForm");
                    var data = data_form.serialize();
                    $.ajax({
                      url: ref,
                      type: 'POST',
                      data: data,
                      dataType: "json",
                      success: function (response) {
                        if (response.code === 0) {
                          layer.close(index);
                          window.location.reload();
                        } else {
                          parse_msg_show_tips(layero, response.msg);
                        }
                      }
                    });
                  }, success: function () {
                    layui.use('form', function () {
                      var form = layui.form;
                      form.render();
                    });
                  }
                });
              }
            });
            break;
          case "emergency_button":
            $.ajax({
              url: ref,
              type: 'GET',
              dataType: 'html',
              success: function (res) {
                layer.open({
                  type: 1,
                  zIndex: 2219,
                  area: ["auto", "auto"],
                  title: gettext('Export who is at work during an emergency'),
                  content: res,
                  btn: ["Submit", "Close"],
                  yes: function (index, layero) {
                    var url = "/iclock/api/transactions/export/?emergency_export_working_employee=1";
                    url += "&export_type=" + $('#id_export_type option:selected', layero).val() + "&date="
                           + $("#id_emergency_date", layero).val();
                    // window.location.href = url;
                    window.open(url, '_blank')
                    layer.close(index);
                  }
                });
              }
            });
            break;
          case "guide":
            let dash_board = $("#dashboard"),
              subscription = $("#subscription"),
              main_body = $("#main_body"),
              side_menu = $("#side_menu"),
              guide = $("#guide");
            dash_board.addClass("layui-hide"); // .remove();
            subscription.addClass("layui-hide");
            main_body.addClass("layui-hide");
            side_menu.addClass("layui-hide");
            guide.removeClass("layui-hide");
            var max_height = Math.floor($('body').height() - 65 - 30 - 6 - (Math.random() * 11));
            $('.easy-user-guide').css({
              'height': max_height
            });


            break;
          default:
            break;
        }
        $('.layui-nav.layui-layout-right dd.layui-this').removeClass('layui-this');
      });
    });

    /// pin tab related event handler
    function _pin_tab(lay_id, options) {
      var op = null, repr = null, module = null,
        done_callback = null, fail_callback = null;

      if (options) {
        op = options['op'];
        module = options['module'];
        repr = options['repr'];
        done_callback = options['done_callback'];
        fail_callback = options['fail_callback'];
      }

      if (!op) {
        op = 'append';
      }
      if (!repr) {
        repr = 'pin';
      }
      if (!module) {
        module = get_module_name();
      }

      $.ajax({
        type: 'POST',
        url: opts.pin_tab_url,
        data: {
          op: op,
          module: module,
          // pin_hex: lay_id,
          pin_url: decodeHex(lay_id)
        },
        dataType: 'json',
        success: function (res) {
          if (res.code === 0) {
            var _msg = res.msg;
            if (_msg === undefined) {
              _msg = repr + ' ' + gettext('message_response_successful');
            }
            layer.msg(gettext(_msg), {
              icon: 1,
              time: '1500',
              shade: 0.1
            });
            if (done_callback) {
              done_callback.call(this);
            }
          } else {
            parse_msg_show_tips(null, res.msg);
            if (fail_callback) {
              fail_callback.call(this);
            }
          }
        }, error: function () {
          // console.log('# unpin failed', arguments);
          error_prompt(repr + ' ' + gettext('message_response_failed'), 'auto');
        }
      });
    }

    $.fn.pin_tab = _pin_tab;

    $('#zk-layui-tab-ul').on('click', 'i.fa-thumb-tack.pined-tab', function () {
      var elem = $(this),
        tab_li = elem.closest('li[lay-id]'),
        lay_id = tab_li ? tab_li.attr('lay-id') : '';
      if (lay_id.length > 0) {
        layer.confirm(gettext('sure_to_unpin'), {
          title: gettext('pop_window_title')
          ,btn: [gettext('btn_confirm'), gettext('btn_cancel')]
        }, function () {
          // noinspection ES6ModulesDependencies
          _pin_tab.apply(elem, [lay_id, {
            op: 'remove',
            repr: 'unpin',
            done_callback: function () {
              elem.remove();
              var tag_a = $(interpolate('.layui-nav-item.side-menu-group dl>dd>a[hex=%s]', [lay_id]));
              tag_a.removeClass('pined-tab-item');
              tag_a.find('i.fa-thumb-tack.pined-tab').remove();
            }
          }]);
        });
      }
    });
  };

  function set_arrow_offset(arrow, tag_a_rect) {
    arrow.css({
      // magic number 23 for IE  browser
      left: tag_a_rect.left + (tag_a_rect.width - (parseInt(getComputedStyle(arrow.get(0), null).width) || 23)) / 2
    });
  }

  //: get all actions related properties caches
  function get_action_cache(force_update) {
    var request_user_id, _url, action_cache_key, last_cached_value;

    if (force_update === undefined || type(force_update) !== 'boolean') {
      force_update = false;
    }
    request_user_id = window['get_session_storage']('request_user_id');
    _url = window['get_session_storage']('cached_actions_url');

    action_cache_key = request_user_id + '_cached_actions';
    last_cached_value = window['get_session_storage'](action_cache_key);

    if (force_update || last_cached_value === null) {
      $.ajax({
        url: _url
        , type: "GET"
        , dataType: "json"
        , success: function (res) {
          console.debug('the caches of user actions were set');
          var to_insert = [];
          $.each(res.data, function (module_name, module_actions) {
            $.each(module_actions, function (cur_model_name, actions) {
              var curr_actions_repr = actions.join('\0\0').replace(/\s*/g, '').toLowerCase();
              to_insert.push([module_name, cur_model_name, curr_actions_repr]);
            });
          });
          $.each(to_insert, function (idx, arr) {
            res.data[arr[0]][arr[1] + '__repr'] = arr[2];
          });
          window['set_session_storage'](request_user_id + '_cached_actions', JSON.stringify(res.data));
        }
      });
    }
  }

  $.fn.get_action_cache = get_action_cache;

  function detect_overlapping_element(elem) {
    var elem_node = elem.get(0),
      rect = elem_node.getBoundingClientRect(),
      _x = rect.left,
      _y = rect.top,
      top_elem = document.elementFromPoint(_x, _y);
    return !top_elem.isSameNode(elem_node);
  }

  $.fn.detect_overlapping_element = detect_overlapping_element;

  function reveal_search_form_if_hidden() {
    var model_name = $.fn.get_model_name_from_hex(),
      $fixed_search_form = '.fixed-search-form',
      search_form = $($fixed_search_form, '#tab_' + model_name),
      all_inline = search_form.find('.layui-inline'),
      _need_padding = false;

    if (all_inline.length) {
      var reversed_elements = all_inline.toArray().reverse(), i, n;
      for (i = 0, n = reversed_elements.length - 1; i < n; i++) {
        var elem = reversed_elements[i],
          $elem = $(elem);
        if ($.fn.detect_overlapping_element($elem)) {
          _need_padding = true;
          break;
        }
      }
      if (_need_padding) {
        var card_header = search_form.closest('.layui-card-header'),
          // card_body = card_header.siblings('.layui-card-body'),
          header_rect = card_header.get(0).getBoundingClientRect(),
          height_already_occupied = header_rect.height,
          form_rect = search_form.get(0).getBoundingClientRect(),
          height_actual_required = form_rect.height,
          padding_height = height_actual_required - height_already_occupied;
        if (padding_height > 0) {
          card_header.css({
            'height': height_actual_required
          });
          // card_body.css({
          //   'padding-top': padding_height
          // });
        }
      }
    }
  }
  $.fn.reveal_search_form_if_hidden = reveal_search_form_if_hidden;

  /**
   *
   * @param _wrapper: selector of container
   * @param trait: trait of item
   * @returns {number}
   */
  function adjust_label_width_dynamically(_wrapper, trait) {
    var rectified_width = -1;
    if (type(_wrapper) !== 'array') {
      _wrapper = [_wrapper];
    }

    if (trait === undefined) {
      trait = '.layui-form-label';
    }

    _.each(_wrapper, function (_container) {
      if (!_container instanceof jQuery) {
        _container = $(_container);
      }
      if (_container.length === 0) {
        return;
      }
      _.each(_container, function (inner) {
        var $inner = $(inner),
          all_labels = $inner.find(trait),
          max_width = _.reduce(all_labels, function (widest, label) {
            var $label = $(label),
              _style = window.getComputedStyle($label.get(0), 'none'),
              elem_width = get_text_width.call($label, $label.text(), _style['font'], true);
            return elem_width > widest ? elem_width : widest;
          }, 0),
          rectified_width = Math.ceil(Math.min(max_width + Math.ceil(Math.random() * 3), CONST_MAX_LABEL_WIDTH));
        all_labels.css({
          maxWidth: rectified_width,
          width: rectified_width
        });
      });
    });
    return rectified_width;
  }

  $.fn.adjust_label_width_dynamically = adjust_label_width_dynamically;

  function set_layui_content_max_height() {

    // -65(nav_top) - 30(tab_title_area) - 6(progress_bar)
    var max_height = Math.floor($('body').height() - 65 - 30 - 6 - (Math.random() * 11));
    // console.log('current max_height', max_height);
    $('#main_body .layui-tab-item.layui-show').css({
      'height': max_height
    });

    $('#dashboard').css({
      'height': max_height,
    });


  }

  $.fn.set_layui_content_max_height = set_layui_content_max_height;

  // call it in first time
  setTimeout(function () {
    set_layui_content_max_height();
  }, CONST_FIRST_RESIZE_TRIGGER_DELAY * CONST_BASE_TIME_UNIT);

  function adjust_fixed_bar_misplace_if_any(model_name) {
    if (model_name === undefined) {
      model_name = $.fn.get_model_name_from_hex();
    }

    var fluid_container = $(interpolate('#%s_fluid', [model_name], '')),
      table_view = $('.layui-table-view', fluid_container);

    if (!table_view.length) {
      return;
    }

    var table_main = $('.layui-table-body.layui-table-main', table_view),
      left_fixed_body = $('.layui-table-box > .layui-table-fixed.layui-table-fixed-l > .layui-table-body', table_view),
      last_fixed_tr = $('table tbody tr', left_fixed_body).last(),
      layui_table_page = $('.layui-table-page', fluid_container),
      offset_array = [-1, 0, 1],
      new_height = table_main.get(0).getBoundingClientRect().height - 10 +
                   offset_array[Math.floor(Math.random() * offset_array.length)];

    if (!(last_fixed_tr.length && layui_table_page.length)) {
      return;
    }

    var last_fixed_tr_rect = last_fixed_tr.get(0).getBoundingClientRect(),
      layui_table_page_rect = layui_table_page.get(0).getBoundingClientRect();
    // only adjust when the top position of last `tr` elem larger than layui page area
    if (last_fixed_tr_rect.top > layui_table_page_rect.top && left_fixed_body.length) {
      left_fixed_body.css({
        'height': new_height
      });
    }
  }

  $.fn.adjust_fixed_bar_misplace_if_any = adjust_fixed_bar_misplace_if_any;

  function resize_side_ztree_if_any() {
    console.debug('resize_side_ztree_if_any');
    setTimeout(function () {
      var model_name = $.fn.get_model_name_from_hex(),
        div_ztree = $('#' + model_name + '_tree'),
        height = $(interpolate('.layui-table-view[lay-id=%s]', ['id_grid_' + model_name])).height();
      div_ztree.closest('.layui-card-body').css({
        overflow: 'auto',
        'height': height - 28 // -28(card-header)
      });
      div_ztree.closest('.layui-card').css({'height': height});
    }, 100);
  }

  $.fn.resize_side_ztree_if_any = resize_side_ztree_if_any;

  function set_new_height_of_table() {
    var model_name = $.fn.get_model_name_from_hex(),
      new_height = $.fn.get_available_area_of_table(get_except_limit(model_name), 10);
    adjust_height_of_table(model_name, new_height);
    $.fn.adjust_fixed_bar_misplace_if_any(model_name);
  }

  $.fn.set_new_height_of_table = set_new_height_of_table;

  /**
   *
   * @param module_name
   * @param tab_id [tab_id]
   */
  function re_login_handler(module_name, tab_id) {
    window['set_session_storage']($.fn.adminSite.const.LAST_SESSION, JSON.stringify({
      module: module_name,
      tabs: (function (current_id) {
        var result = [];
        $('>li', '#zk-layui-tab-ul').each(function (index, elem) {
          var $elem = $(elem);
          result.push($elem.attr('lay-id'));
        });
        if (current_id && !result.includes(current_id)) {
          result.push(current_id);
        }
        return result;
      })(tab_id)
    }));
    show_prompt(gettext('You have successfully logged out of the application please login to continue'), {
      time: 3000,
      shade: ['#fff', 0.3],
      end: function () {
        window.location = '/login/';
      }
    });
  }

  $.fn.re_login_handler = re_login_handler;

  function get_specific_layer(layer_id) {
    return $('#layui-layer' + layer_id);
  }

  $.fn.get_specific_layer = get_specific_layer;

  function _full_screen_iterate(doc, api_dialects) {
    var i, n, promise = null;
    for (i = 0, n = api_dialects.length; i < n; i++) {
      var dialect_name = api_dialects[i], dialect_func = doc[dialect_name];
      // in case of error:
      // Uncaught (in promise) TypeError: Failed to execute 'requestFullscreen' on 'Element': Illegal invocation
      if (dialect_func && type(dialect_func) === 'function') {
        promise = dialect_func.call(doc);
        break;
      }
    }
    return promise;
  }

  function request_full_screen() {
    var doc = document.documentElement, api_dialects = [
      'requestFullscreen', 'mozRequestFullScreen', 'webkitRequestFullScreen', 'msRequestFullscreen'
    ];
    return _full_screen_iterate(doc, api_dialects);
  }

  function cancel_full_screen() {
    var api_dialects = [
      'exitFullscreen', 'mozCancelFullScreen', 'webkitCancelFullScreen', 'msExitFullscreen'
    ];
    return _full_screen_iterate(document, api_dialects);
  }

  $.fn.request_full_screen = request_full_screen;
  $.fn.cancel_full_screen = cancel_full_screen;


  /**
   * add resize event monitor
   * @desc
   * Since resize events can fire at a high rate,
   * the event handler shouldn't execute computationally expensive operations such as DOM modifications.
   * Instead, we utilize throttle technology to limit its actual trigger rate;
   * @type {{add}}: add callback function to trigger on window resize
   */
  var optimizedResize = (function () {
    var callbacks = [],
      max_event_coexist = 10,
      running = false;

    // fired on resize event
    function resize(e) {
      var this_ = this,
        callback_wrapper = function () {
          runCallbacks.call(this_, e);
        };
      if (!running) {
        running = true;
        if (window.requestAnimationFrame) {
          window.requestAnimationFrame(callback_wrapper);
        } else {
          // The actualResizeHandler will execute at a rate of 16fps
          setTimeout(callback_wrapper, Math.floor(CONST_BASE_TIME_UNIT / CONST_FRAME_FPS));
        }
      }
    }

    // run the actual callbacks
    function runCallbacks(e) {
      var this_ = this;
      callbacks.forEach(function (callback) {
        callback.call(this_, e);
      });
      running = false;
    }

    // adds callback to loop
    function addCallback(callback) {
      if (callback) {
        callbacks.push(callback);
        while (callbacks.length > max_event_coexist) {
          callbacks.shift();
        }
      }
    }

    return {
      // public method to add additional callback
      /**
       *
       * @param callback_list {Array|Object}
       */
      add: function (callback_list) {
        if (!callbacks.length) {
          window.addEventListener('resize', resize);
        }
        if (type(callback_list) === 'object') {
          callback_list = get_prop_from_iterable(callback_list, 'values');
        } else if (type(callback_list) !== 'array') {
          callback_list = [callback_list];
        }
        callback_list.forEach(function (func/*, index*/) {
          addCallback(func);
        });
      }
    };
  }());

  // start process
  optimizedResize.add({
    // callback for set layui content
    'resize_layui_content': set_layui_content_max_height,
    // callback for remove bland area after last column
    'set_new_height_of_table': set_new_height_of_table,
    'remove_blank_area_after_last_column': function () {
      var model_name = $.fn.get_model_name_from_hex();
      setTimeout(function () {
        $.fn.trigger_action_auto(model_name, 'fit');
      }, CONST_BASE_TIME_UNIT / 10);
      setTimeout(function () {
        $.fn.trigger_action_auto_review(model_name);
      }, CONST_BASE_TIME_UNIT / Math.ceil(Math.random() * 5));
    },
    'resize_tab_if_any': function () {
      var $tab_header = '#zk-layui-tab',
        tabs_to_resize = $('>ul>li:not(.layui-this)', $tab_header), tabs_need_scale_full;

      var cur_height = window.innerHeight, cur_width = window.innerWidth,
        cur_dimension = [cur_width, cur_height];
      if (tabs_to_resize.length) {
        // in fullscreen mode
        if (is_fullscreen()) {
          window['set_session_storage'](KEY_DIMENSION_OF_FULLSCREEN, JSON.stringify([window.innerWidth, window.innerHeight]));
          tabs_need_scale_full = tabs_to_resize.not('.need-scale-full');
          tabs_need_scale_full.removeClass().addClass('need-scale-full');
        } else {
          var last_dimension = JSON.parse(window['get_session_storage'](KEY_DIMENSION_OF_LAST_RESIZE || '[]'))
            , dimension_before_fullscreen = JSON.parse(window['get_session_storage'](KEY_DIMENSION_BEFORE_FULLSCREEN));
          if (dimension_before_fullscreen && isArraysEqual(cur_dimension, dimension_before_fullscreen)) {
            tabs_to_resize.removeClass('need-scale-full').addClass('need-scale-restore');
          } else {
            if (last_dimension && last_dimension.length) {
              var x_axis_changed = false, y_axis_changed = false;
              if (last_dimension[0] !== cur_width) {
                x_axis_changed = true;
              }
              if (last_dimension[1] !== cur_height) {
                y_axis_changed = true;
              }
              if (x_axis_changed && y_axis_changed) {
                tabs_to_resize.removeClass().addClass('need-scale-dual');
              } else if (x_axis_changed) {
                tabs_to_resize.removeClass().addClass('need-scale-x');
              } else {
                tabs_to_resize.removeClass().addClass('need-scale-y');
              }
            } else {
              // if system don't conceive last dimension, then suppose it need resize two dimensions
              tabs_to_resize.removeClass().addClass('need-scale-dual');
            }
          }
          // detect return from full-screen
        }
      }
      // console.log({'cur_dimension': cur_dimension});
      window['set_session_storage'](KEY_DIMENSION_OF_LAST_RESIZE, JSON.stringify(cur_dimension));
    },
    'resize_side_ztree_if_any': resize_side_ztree_if_any,
    'reveal_search_form_if_hidden': reveal_search_form_if_hidden
  });

  $(window).keydown(_.debounce(function (event) {
    var code = event.keyCode || event.which;
    // press F11 key
    if (code === 122) {
      if (!is_fullscreen()) {
        // console.log('dimension_before_fullscreen');
        window['set_session_storage'](KEY_DIMENSION_BEFORE_FULLSCREEN, JSON.stringify([window.innerWidth, window.innerHeight]));
      }
    }
  }));

  $.fn.adminSite.const = {
    TABS_RESTORE_NOTIFY_ID: '__tabs_restore_notify_id__',
    IS_USER_TRIGGERED: '__is_user_triggered__',
    LAST_SESSION: '__last_session__',
    NOT_MORE_FIELD_HINTS: '__not_more_field_hints_',
    SKIN_CSS_BACKGROUND: '__skin_background__',
    ARCHIVED_SESSION: '__archived_session__',
    CONST_CURRENT_TAB_TITLE_AREA: '#zk-layui-tab-ul > .layui-this'
  };
  // noinspection ES6ModulesDependencies
  $.fn.adminSite.defaults = {
    base_path: 'static/extends',
    pined_tab: '<i class="fa fa-fw fa-thumb-tack pined-tab" aria-hidden="true"></i>'
  };
})(jQuery);
